/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jsbsoft.jtf.monitoring.impl;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.identification.GestionnaireIdentification;
import com.jsbsoft.jtf.monitoring.AbsModuleMonitoring;

/**
 * The Class ModuleChargementSessionUtilisateur.
 */
public class ModuleChargementSessionUtilisateur extends AbsModuleMonitoring {

	/** The Constant MODULE_CODE. */
	public final static String MODULE_CODE = "chargt_user";

	/** The Constant MODULE_INTITULE. */
	public final static String MODULE_INTITULE = "Chargement session utilisateur";

	/** The Constant MODULE_PARAM_UTILISATEUR. */
	public final static String MODULE_PARAM_UTILISATEUR = "login";

	/** The _log. */
	private static final Logger LOG = LoggerFactory.getLogger(ModuleChargementSessionUtilisateur.class);

	/**
	 * Instantiates a new module chargement session utilisateur.
	 */
	public ModuleChargementSessionUtilisateur() {
		super(MODULE_CODE, MODULE_INTITULE);
	}

	/* (non-Javadoc)
	 * @see com.jsbsoft.jtf.monitoring.AbsModuleMonitoring#executer(java.lang.String, com.jsbsoft.jtf.database.OMContext, javax.servlet.http.HttpServletRequest)
	 */
	@Override
	public ResExec executer(String intituleScenario, OMContext ctx, HttpServletRequest req) {
		String codeUtilisateur = getParametre(MODULE_PARAM_UTILISATEUR);
		ResExec res;
		if (codeUtilisateur != null) {
			long tps = System.currentTimeMillis();
			try {
				boolean resultat = GestionnaireIdentification.getInstance().chargeInfoUser(codeUtilisateur, ctx, req.getSession(Boolean.FALSE), req.getHeader("user-agent"));
				tps = System.currentTimeMillis() - tps;
				if (resultat) {
					res = new ResExec(intituleScenario, MODULE_INTITULE, getCodeErreurTpsExec(tps), "Chargement OK de l'utilisateur " + codeUtilisateur, tps);
				} else {
					res = new ResExec(intituleScenario, MODULE_INTITULE, CODE_ERREUR_RESULTAT_EXECUTION_ERREUR, "Utilisateur " + codeUtilisateur + " inconnu", tps);
				}
			} catch (Exception e) {
				res = new ResExec(intituleScenario, MODULE_INTITULE, CODE_ERREUR_RESULTAT_EXECUTION_ERREUR, "Echec chargement de l'utilisateur " + codeUtilisateur);
				LOG.error("Echec chargement de l'utilisateur " + codeUtilisateur, e);
			}
		} else {
			res = new ResExec(intituleScenario, MODULE_INTITULE, CODE_ERREUR_RESULTAT_EXECUTION_ERREUR, "Echec : aucun code utilisateur");
		}
		return res;
	}
}
