/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jsbsoft.jtf.monitoring.impl;

import javax.servlet.http.HttpServletRequest;

import com.jsbsoft.jtf.database.BasicPoolMgr;
import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.monitoring.AbsModuleMonitoring;

/**
 * The Class ModuleMySQL.
 */
public class ModuleMySQL extends AbsModuleMonitoring {

	/** The Constant MODULE_PARAM_NB_CONNEXIONS_OUVERTES_WARNING. */
	public final static String MODULE_PARAM_NB_CONNEXIONS_OUVERTES_WARNING = "nb_connexions_ouvertes_warning";

	/** The Constant MODULE_PARAM_NB_CONNEXIONS_OUVERTES_CRITIQUE. */
	public final static String MODULE_PARAM_NB_CONNEXIONS_OUVERTES_CRITIQUE = "nb_connexions_ouvertes_critique";

	/** The Constant MODULE_CODE. */
	public final static String MODULE_CODE = "mysql";

	/** The Constant MODULE_INTITULE. */
	public final static String MODULE_INTITULE = "Charge mySQL";

	/**
	 * Instantiates a new module my sql.
	 */
	public ModuleMySQL() {
		super(MODULE_CODE, MODULE_INTITULE);
	}

	/* (non-Javadoc)
	 * @see com.jsbsoft.jtf.monitoring.AbsModuleMonitoring#executer(java.lang.String, com.jsbsoft.jtf.database.OMContext, javax.servlet.http.HttpServletRequest)
	 */
	@Override
	public ResExec executer(String intiutleScenario, OMContext ctx, HttpServletRequest req) {
		int nbConnexionsOuvertes = BasicPoolMgr.getNombreConnexionsOuvertes();
		int nbConnexionsOuvertesWarning = Integer.parseInt(getParametre(MODULE_PARAM_NB_CONNEXIONS_OUVERTES_WARNING));
		int nbConnexionsOuvertesCritique = Integer.parseInt(getParametre(MODULE_PARAM_NB_CONNEXIONS_OUVERTES_CRITIQUE));
		if (nbConnexionsOuvertes < nbConnexionsOuvertesWarning) {
			return new ResExec(intiutleScenario, MODULE_INTITULE, CODE_ERREUR_RESULTAT_EXECUTION_OK, "Nombre de connexions ouvertes OK : " + nbConnexionsOuvertes);
		} else if (nbConnexionsOuvertes >= nbConnexionsOuvertesCritique) {
			return new ResExec(intiutleScenario, MODULE_INTITULE, CODE_ERREUR_RESULTAT_EXECUTION_ERREUR, "Nombre de connexions ouvertes KO : " + nbConnexionsOuvertes);
		} else {
			return new ResExec(intiutleScenario, MODULE_INTITULE, CODE_ERREUR_RESULTAT_EXECUTION_WARNING, "Nombre de connexions ouvertes : " + nbConnexionsOuvertes);
		}
	}
}
