/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jsbsoft.jtf.stats;

/**
 * Interface definissant les constantes pour l'etablissement de statistiques.
 * 
 * @author jbiard
 */
public interface IStats {

	// expression reguliere des items pour le message de log
	/** The SWITC h_ regexp. */
	String SWITCH_REGEXP = "%[a-z]+";

	// items des " infos standard "
	/** The SWITC h_ adress e_ ip. */
	String SWITCH_ADRESSE_IP = "%adresseip";

	/** The SWITC h_ ksession. */
	String SWITCH_KSESSION = "%ksession";

	/** The SWITC h_ profi l_ dsi. */
	String SWITCH_PROFIL_DSI = "%profildsi";

	// interface de saisie
	/** The SWITC h_ i f_ saisie. */
	String SWITCH_IF_SAISIE = "%ifsaisie";

	/** The SWITC h_ obje t_ libelle. */
	String SWITCH_OBJET_LIBELLE = "%libelleobjet";

	/** The SWITC h_ obje t_ action. */
	String SWITCH_OBJET_ACTION = "%actionobjet";

	/** The SWITC h_ ru b_ libelle. */
	String SWITCH_RUB_LIBELLE = "%libellerub";

	/** The SWITC h_ servic e_ libelle. */
	String SWITCH_SERVICE_LIBELLE = "%libelleservice";

	// identifiant de log
	/** The I d_ lo g_ service. */
	String ID_LOG_SERVICE = "service";

	/** The I d_ lo g_ contrib. */
	String ID_LOG_CONTRIB = "contrib";

	/** The I f_ bo. */
	String IF_BO = "BO";

	/** The I f_ fo. */
	String IF_FO = "FO";

	/** The ACTIO n_ obje t_ consultation. */
	String ACTION_OBJET_CONSULTATION = "CONSULTATION";
}
