/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jsbsoft.jtf.stats;

import javax.servlet.http.HttpServletRequest;

import com.jsbsoft.jtf.database.OMContext;
import com.univ.utils.ContexteUniv;

/**
 * Classe permettant de determiner la valeur d'un switch.
 * 
 * @author jbiard
 */
public class InfosStats implements IStats {

	/**
	 * Retourne la valeur d'un switch suivant le contenu du contexte.
	 * 
	 * @param ctx
	 *            contexte
	 * @param switch_
	 *            switch dont la valeur est a determiner
	 * 
	 * @return valeur du switch
	 */
	public String getInfos(OMContext ctx, String switch_) {
		if (ctx != null) {
			// switches du ContexteUniv
			if (ctx instanceof ContexteUniv) {
				ContexteUniv ctxUniv = (ContexteUniv) ctx;
				if (switch_.equals(SWITCH_KSESSION)) {
					return ctxUniv.getKsession();
				} else if (switch_.equals(SWITCH_ADRESSE_IP)) {
					HttpServletRequest request = ctxUniv.getRequeteHTTP();
					if (request != null) {
						return ctxUniv.getRequeteHTTP().getRemoteAddr();
					}
				} else if (switch_.equals(SWITCH_PROFIL_DSI)) {
					return ctxUniv.getProfilDsi();
				}
			}
		}
		return null;
	}
}
