/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jsbsoft.jtf.textsearch;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kportal.cache.CacheUtil;
import net.sf.ehcache.Cache;
import org.springframework.stereotype.Component;

@Component
public class CacheIndexerManager {

	public static final String ID_BEAN = "cacheIndexerManager";

	public static final String CACHE_NAME = "IndexerJob.deletedObject";

	/*
	 * Instance du proxy pour appeler directement les méthodes sur ce singleton
	 */
	public static CacheIndexerManager getInstance() {
		return (CacheIndexerManager) ApplicationContextManager.getCoreContextBean(ID_BEAN);
	}

	public Cache getCache() {
		return CacheUtil.getCacheManager().getCache(CACHE_NAME);
	}

	public Object get(Object key) {
		return CacheUtil.getObjectValue(CACHE_NAME, key);
	}

	public void evict(Object key) {
		CacheUtil.flush(CACHE_NAME, key);
	}

	public void addOrUpdate(Integer key, Object value) {
		CacheUtil.updateObjectValue(CACHE_NAME, key, value);
	}
}