/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jsbsoft.jtf.textsearch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jsbsoft.jtf.webutils.ContextePage;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.ReferentielObjets;

/**
 * The Class FirstIndex.
 * 
 * @author malice
 */
public class FirstIndex {

	/** The _log. */
	private static final Logger LOG = LoggerFactory.getLogger(FirstIndex.class);

	/**
	 * Instantiates a new first index.
	 */
	public FirstIndex() {
		super();
	}

	/**
	 * The main method.
	 * 
	 * @param args
	 *            the arguments
	 */
	public static void main(final String[] args) {
		String listeobjetsexclus = "";
		String listeobjetsinclus = "";
		//on peut ne pas indexer certains objets
		if (args.length > 0 && args[0].startsWith("-exclure")) {
			listeobjetsexclus = args[1];
		} else if (args.length > 0 && args[0].startsWith("-inclure")) {
			listeobjetsinclus = args[1];
		}
		final long debut = System.currentTimeMillis();
		final ArrayList<String> vObjetsExclus = new ArrayList<>();
		if (!listeobjetsexclus.equals("")) {
			final String[] sListeExclus = listeobjetsexclus.split(",");
			Collections.addAll(vObjetsExclus, sListeExclus);
		}
		final ArrayList<String> vObjetsInclus = new ArrayList<>();
		if (!"".equals(listeobjetsinclus)) {
			final String[] sListeInclus = listeobjetsinclus.split(",");
			Collections.addAll(vObjetsInclus, sListeInclus);
		}
		String criteredate = "";
		//on indexe uniquement les fiches modifiées ou créées le jour même
		if (args.length > 2) {
			criteredate = args[1];
		}
		if (args.length > 0 && args[0].equals("-date")) {
			criteredate = args[0];
		}
		boolean start = true;
		final ContextePage ctx = new ContextePage("");
		ctx.setConnectionLongue(true);
		try {
			if (!criteredate.equals("")) {
				final java.sql.Date today = new java.sql.Date((new GregorianCalendar()).getTimeInMillis());
				criteredate = " AND (DATE_FORMAT(DATE_CREATION, '%Y-%m-%d')='" + today + "' OR DATE_FORMAT(DATE_MODIFICATION, '%Y-%m-%d')='" + today + "')";
				LOG.info("*** Début de l'indexation des fiches créées ou modifiées aujourd'hui ***");
				LOG.info(criteredate);
			} else {
				LOG.info("*** Début de l'indexation des fiches ***");
			}
			final Collection<String> listeObjets = ReferentielObjets.getListeNomsObjet();
			// instance
			final Indexer indexer = Indexer.getInstance();
			try {
				if (indexer.getWriter() != null) {
					throw new Exception("writer en cours d'exécution");
				}
				// initialisation des writers
				indexer.initWriter();
				//pour chaque objet, on indexe les pages en ligne
				for (final String nom : listeObjets) {
					//si l'objet est exclu, on passe le tour, ou qu'il n'est pas dans la liste des inclus
					if (vObjetsExclus.contains(nom) || (vObjetsInclus.size() > 0 && !vObjetsInclus.contains(nom))) {
						LOG.info("Les fiches '" + nom + "' ne seront pas indexées");
						continue;
					}
					LOG.info("*** objet : " + nom + " ***");
					FicheUniv fiche = ReferentielObjets.instancierFiche(nom);
					fiche.setCtx(ctx);
					// suppression des index existants pour le type de fiche
					if (indexer.deleteFicheByType(nom)) {
						if (start) {
							start = false;
						}
						//on indexe les fiches en ligne et les fiches à supprimer (pour le cas où ce script est lancé après un import)
						if (fiche.select("WHERE ETAT_OBJET IN ('0003','0004')" + criteredate) > 0) {
							while (fiche.nextItem()) {
								LOG.info("fiche : " + fiche.getLibelleAffichable());
								try {
									indexer.indexFiche(ctx, fiche, false);
								} catch (final Exception e) {
									LOG.error("Exception lors de l'indexation de la fiche : " + fiche.getLibelleAffichable(), e);
								}
							}
						}
					} else {
						LOG.error("Impossible d'indexer les fiches " + nom);
					}
				}
			} catch (final Exception e) {
				LOG.error("Exception Batch FirstIndex : " + e.getMessage());
			} finally {
				// optimisation des indexs
				indexer.optimisation();
				indexer.closeWriter();
			}
			int i = new Integer(Long.toString((System.currentTimeMillis() - debut) / 1000));
			String heure = "00";
			String min = "00";
			String sec = "00";
			if (i > 3600) {
				int t = i / 3600;
				if (t < 10) {
					heure = "0" + Integer.toString(t);
				} else {
					heure = Integer.toString(t);
				}
				i = (i - (t * 60));
				if (i > 60) {
					t = i / 60;
					if (t < 10) {
						min = "0" + Integer.toString(t);
					} else {
						min = Integer.toString(t);
					}
					t = i - (t * 60);
					if (t < 10) {
						sec = "0" + Integer.toString(t);
					} else {
						sec = Integer.toString(t);
					}
				}
			} else if (i > 60) {
				int t = i / 60;
				if (t < 10) {
					min = "0" + Integer.toString(t);
				} else {
					min = Integer.toString(t);
				}
				t = i - (t * 60);
				if (t < 10) {
					sec = "0" + Integer.toString(t);
				} else {
					sec = Integer.toString(t);
				}
			} else {
				if (i < 10) {
					sec = "0" + Integer.toString(i);
				} else {
					sec = Integer.toString(i);
				}
			}
			LOG.info("*** Fin de l'indexation ( durée : " + heure + ":" + min + ":" + sec + " ) ***");
		} catch (final Exception e) {
			LOG.error(e.getMessage(), e);
		} finally {
			ctx.release();
		}
	}
}
