/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Created on 7 avr. 2005
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package com.jsbsoft.jtf.textsearch;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.CompressionTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jsbsoft.jtf.textsearch.util.SearchPropertiesHelper;

/**
 * The Class Index.
 *
 * @author Administrateur
 *
 *         To change the template for this generated type comment go to Window - Preferences - Java - Code Generation - Code and Comments
 */
public class Index {

	/** The content. */
	private String content = null;

	/** The content file. */
	private String contentFile = null;

	/** The code rubrique. */
	private List<String> codeRubrique = null;

	/** The code site. */
	private String codeSite = null;

	/** The code rattachement. */
	private List<String> codeRattachement = null;

	/** The code fiche. */
	private String codeFiche = null;

	private String codeRedacteur = null;

	/** The id fiche. */
	private String idFiche = null;

	/** The etat fiche. */
	private String etatFiche = null;

	/** The langue. */
	private String langue = null;

	/** The objet. */
	private String objet = null;

	/** The public vise. */
	private String publicVise = null;

	/** The public vise restriction. */
	private String publicViseRestriction = null;

	/** The mode restriction. */
	private String modeRestriction = null;

	/** The identifiant unique. */
	private String identifiantUnique = null;

	/** The last modified. */
	private String lastModified = null;

	/** The code espace. */
	private String codeEspace = null;

	/** The url. */
	private String url = null;

	/** The title. */
	private String title = null;

	/** The keywords. */
	private String keywords = null;

	/** The description. */
	private String description = null;

	/** The mise en ligne. */
	private String miseEnLigne = null;

	/** The Constant CONTENT. */
	public final static String CONTENT = "contenu";

	/** The Constant CONTENT_FILE. */
	public final static String CONTENT_FILE = "contenu_fichiers";

	/** The Constant CODE_RUBRIQUE. */
	public final static String CODE_RUBRIQUE = "code_rubrique";

	/** The Constant CODE_RATTACHEMENT. */
	public final static String CODE_RATTACHEMENT = "code_rattachement";

	/** The Constant CODE_FICHE. */
	public final static String CODE_FICHE = "code";

	/** The Constant CODE_SITE. */
	public final static String CODE_SITE = "code_site";

	/** The Constant CODE_SITE. */
	public final static String CODE_REDACTEUR = "code_redacteur";

	/** The Constant ID_FICHE. */
	public final static String ID_FICHE = "id_fiche";

	/** The Constant ETAT_FICHE. */
	public final static String ETAT_FICHE = "etat_objet";

	/** The Constant LANGUE. */
	public final static String LANGUE = "langue";

	/** The Constant OBJET. */
	public final static String OBJET = "nom_objet";

	/** The Constant PUBLIC_VISE. */
	public final static String PUBLIC_VISE = "public_vise";

	/** The Constant PUBLIC_VISE_RESTRICTION. */
	public final static String PUBLIC_VISE_RESTRICTION = "public_vise_restriction";

	/** The Constant MODE_RESTRICTION. */
	public final static String MODE_RESTRICTION = "mode_restriction";

	/** The Constant IDENTIFIANT_UNIQUE. */
	public final static String IDENTIFIANT_UNIQUE = "id_unique";

	/** The Constant LAST_MODIFIED. */
	public final static String LAST_MODIFIED = "date_modification";

	/** The Constant MISE_EN_LIGNE. */
	public final static String MISE_EN_LIGNE = "meta_date_mise_en_ligne";

	/** The Constant CODE_ESPACE. */
	public final static String CODE_ESPACE = "code_espace";

	/** The Constant URL. */
	public final static String URL = "url";

	/** The Constant TITLE. */
	public final static String TITLE = "title";

	/** The Constant KEYWORDS. */
	public final static String KEYWORDS = "keywords";

	/** The Constant DESCRIPTION. */
	public final static String DESCRIPTION = "description";

	private static final Logger LOG = LoggerFactory.getLogger(Index.class);

	/**
	 * Gets the description.
	 *
	 * @return Returns the description.
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * Sets the description.
	 *
	 * @param description
	 *            The description to set.
	 */
	public void setDescription(final String description) {
		this.description = description;
	}

	/**
	 * Gets the code espace.
	 *
	 * @return Returns the codeEspace.
	 */
	public String getCodeEspace() {
		return codeEspace;
	}

	/**
	 * Sets the code espace.
	 *
	 * @param codeEspace
	 *            The codeEspace to set.
	 */
	public void setCodeEspace(final String codeEspace) {
		this.codeEspace = codeEspace;
	}

	/**
	 * Gets the code fiche.
	 *
	 * @return Returns the codeFiche.
	 */
	public String getCodeFiche() {
		return codeFiche;
	}

	/**
	 * Sets the code fiche.
	 *
	 * @param codeFiche
	 *            The codeFiche to set.
	 */
	public void setCodeFiche(final String codeFiche) {
		this.codeFiche = codeFiche;
	}

	/**
	 * Gets the code rattachement.
	 *
	 * @return Returns the codeRattachement.
	 */
	public List<String> getCodeRattachement() {
		return codeRattachement;
	}

	/**
	 * Sets the code rattachement.
	 *
	 * @param codeRattachement
	 *            The codeRattachement to set.
	 */
	public void setCodeRattachement(final List<String> codeRattachement) {
		this.codeRattachement = codeRattachement;
	}

	/**
	 * Gets the code rubrique.
	 *
	 * @return Returns the codeRubrique.
	 */
	public List<String> getCodeRubrique() {
		return codeRubrique;
	}

	/**
	 * Sets the code rubrique.
	 *
	 * @param codeRubrique
	 *            The codeRubrique to set.
	 */
	public void setCodeRubrique(final List<String> codeRubrique) {
		this.codeRubrique = codeRubrique;
	}

	/**
	 * Gets the content.
	 *
	 * @return Returns the content.
	 */
	public String getContent() {
		return content;
	}

	/**
	 * Sets the content.
	 *
	 * @param content
	 *            The content to set.
	 */
	public void setContent(final String content) {
		this.content = content;
	}

	/**
	 * Gets the etat fiche.
	 *
	 * @return Returns the etatFiche.
	 */
	public String getEtatFiche() {
		return etatFiche;
	}

	/**
	 * Sets the etat fiche.
	 *
	 * @param etatFiche
	 *            The etatFiche to set.
	 */
	public void setEtatFiche(final String etatFiche) {
		this.etatFiche = etatFiche;
	}

	/**
	 * Gets the identifiant unique.
	 *
	 * @return Returns the identifiantUnique.
	 */
	public String getIdentifiantUnique() {
		return identifiantUnique;
	}

	/**
	 * Sets the identifiant unique.
	 *
	 * @param identifiantUnique
	 *            The identifiantUnique to set.
	 */
	public void setIdentifiantUnique(final String identifiantUnique) {
		this.identifiantUnique = identifiantUnique;
	}

	/**
	 * Gets the id fiche.
	 *
	 * @return Returns the idFiche.
	 */
	public String getIdFiche() {
		return idFiche;
	}

	/**
	 * Sets the id fiche.
	 *
	 * @param idFiche
	 *            The idFiche to set.
	 */
	public void setIdFiche(final String idFiche) {
		this.idFiche = idFiche;
	}

	/**
	 * Gets the keywords.
	 *
	 * @return Returns the keywords.
	 */
	public String getKeywords() {
		return keywords;
	}

	/**
	 * Sets the keywords.
	 *
	 * @param keywords
	 *            The keywords to set.
	 */
	public void setKeywords(final String keywords) {
		this.keywords = keywords;
	}

	/**
	 * Gets the langue.
	 *
	 * @return Returns the langueFiche.
	 */
	public String getLangue() {
		return langue;
	}

	/**
	 * Sets the langue.
	 *
	 * @param langueFiche
	 *            The langueFiche to set.
	 */
	public void setLangue(final String langueFiche) {
		this.langue = langueFiche;
	}

	/**
	 * Gets the last modified.
	 *
	 * @return Returns the lastModified.
	 */
	public String getLastModified() {
		return lastModified;
	}

	/**
	 * Sets the last modified.
	 *
	 * @param lastModified
	 *            The lastModified to set.
	 */
	public void setLastModified(final String lastModified) {
		this.lastModified = lastModified;
	}

	/**
	 * Gets the mode restriction.
	 *
	 * @return Returns the modeRestriction.
	 */
	public String getModeRestriction() {
		return modeRestriction;
	}

	/**
	 * Sets the mode restriction.
	 *
	 * @param modeRestriction
	 *            The modeRestriction to set.
	 */
	public void setModeRestriction(final String modeRestriction) {
		this.modeRestriction = modeRestriction;
	}

	/**
	 * Gets the objet.
	 *
	 * @return Returns the objet.
	 */
	public String getObjet() {
		return objet;
	}

	/**
	 * Sets the objet.
	 *
	 * @param objet
	 *            The objet to set.
	 */
	public void setObjet(final String objet) {
		this.objet = objet;
	}

	/**
	 * Gets the public vise.
	 *
	 * @return Returns the publicVise.
	 */
	public String getPublicVise() {
		return publicVise;
	}

	/**
	 * Sets the public vise.
	 *
	 * @param publicVise
	 *            The publicVise to set.
	 */
	public void setPublicVise(final String publicVise) {
		this.publicVise = publicVise;
	}

	/**
	 * Gets the public vise restriction.
	 *
	 * @return Returns the publicViseRestriction.
	 */
	public String getPublicViseRestriction() {
		return publicViseRestriction;
	}

	/**
	 * Sets the public vise restriction.
	 *
	 * @param publicViseRestriction
	 *            The publicViseRestriction to set.
	 */
	public void setPublicViseRestriction(final String publicViseRestriction) {
		this.publicViseRestriction = publicViseRestriction;
	}

	/**
	 * Gets the title.
	 *
	 * @return Returns the title.
	 */
	public String getTitle() {
		return title;
	}

	/**
	 * Sets the title.
	 *
	 * @param title
	 *            The title to set.
	 */
	public void setTitle(final String title) {
		this.title = title;
	}

	/**
	 * Gets the url.
	 *
	 * @return Returns the url.
	 */
	public String getUrl() {
		return url;
	}

	/**
	 * Sets the url.
	 *
	 * @param url
	 *            The url to set.
	 */
	public void setUrl(final String url) {
		this.url = url;
	}

	/**
	 * Creer document.
	 *
	 * @return the document
	 *
	 * @throws Exception
	 *             the exception
	 */
	public Document creerDocument() throws Exception {
		//	Création d'un document de type Lucene par fiche
		final Document document = new Document();
		document.add(new Field(IDENTIFIANT_UNIQUE, getIdentifiantUnique(), Field.Store.YES, Field.Index.NOT_ANALYZED));
		//nom de l'objet
		if (getObjet() != null) {
			document.add(new Field(OBJET, getObjet(), Field.Store.YES, Field.Index.NOT_ANALYZED));
		}
		//id de la fiche
		if (getIdFiche() != null) {
			document.add(new Field(ID_FICHE, getIdFiche(), Field.Store.YES, Field.Index.NO));
		}
		//code de la fiche
		if (getCodeFiche() != null) {
			document.add(new Field(CODE_FICHE, getCodeFiche(), Field.Store.YES, Field.Index.NO));
		}
		//code redacteur
		if (getCodeRedacteur() != null) {
			document.add(new Field(CODE_REDACTEUR, getCodeRedacteur(), Field.Store.YES, Field.Index.NO));
		}
		//langue
		if (getLangue() != null) {
			document.add(new Field(LANGUE, getLangue(), Field.Store.YES, Field.Index.NOT_ANALYZED));
		}
		//etat de la fiche
		if (getEtatFiche() != null) {
			document.add(new Field(ETAT_FICHE, getEtatFiche(), Field.Store.YES, Field.Index.NOT_ANALYZED));
		}
		// structure de la fiche
		if (getCodeRattachement() != null) {
			for (final String code : getCodeRattachement()) {
				document.add(new Field(CODE_RATTACHEMENT, code, Field.Store.YES, Field.Index.NOT_ANALYZED));
			}
		}
		//date de modification
		if (getLastModified() != null) {
			document.add(new Field(LAST_MODIFIED, getLastModified(), Field.Store.YES, Field.Index.NOT_ANALYZED));
		}
		//date de mise en ligne
		if (getMiseEnLigne() != null) {
			final Field fieldKeys = new Field(MISE_EN_LIGNE, getMiseEnLigne(), Field.Store.YES, Field.Index.ANALYZED);
			fieldKeys.setBoost(2F);
			document.add(fieldKeys);
		}
		if (StringUtils.isEmpty(getModeRestriction())) {
			modeRestriction = "0";
		}
		document.add(new Field(MODE_RESTRICTION, getModeRestriction(), Field.Store.YES, Field.Index.NOT_ANALYZED));
		if (getPublicVise() != null) {
			document.add(new Field(PUBLIC_VISE, getPublicVise(), Field.Store.YES, Field.Index.NOT_ANALYZED));
		}
		if (getPublicViseRestriction() != null) {
			document.add(new Field(PUBLIC_VISE_RESTRICTION, getPublicViseRestriction(), Field.Store.YES, Field.Index.NOT_ANALYZED));
		}
		if (getCodeRubrique() != null) {
			for (final String code : getCodeRubrique()) {
				document.add(new Field(CODE_RUBRIQUE, code, Field.Store.YES, Field.Index.NOT_ANALYZED));
			}
		}
		if (getCodeSite() != null) {
			document.add(new Field(CODE_SITE, getCodeSite(), Field.Store.YES, Field.Index.NOT_ANALYZED));
		}
		if (getContent() != null) {
			document.add(new Field(CONTENT, getContent(), Field.Store.NO, Field.Index.ANALYZED));
			document.add(new Field(CONTENT, CompressionTools.compress(getContent().getBytes())));
		}
		if (getContentFile() != null) {
			document.add(new Field(CONTENT_FILE, getContentFile(), Field.Store.NO, Field.Index.ANALYZED));
			document.add(new Field(CONTENT_FILE, CompressionTools.compress(getContentFile().getBytes())));
		}
		int boost = 1;
		if (getTitle() != null) {
			try {
				boost = SearchPropertiesHelper.getBoostTitre();
				final Field fieldTitre = new Field(TITLE, getTitle(), Field.Store.YES, Field.Index.ANALYZED);
				fieldTitre.setBoost(boost * 1F);
				document.add(fieldTitre);
			} catch (final Exception e) {
				LOG.error("erreur lors de l'instanciation du field", e);
			}
		}
		if (getDescription() != null) {
			try {
				boost = SearchPropertiesHelper.getBoostMetaDescription();
				final Field fieldKeys = new Field(DESCRIPTION, getDescription(), Field.Store.YES, Field.Index.ANALYZED);
				fieldKeys.setBoost(boost * 1F);
				document.add(fieldKeys);
			} catch (final Exception e) {
				LOG.error("erreur lors de l'instanciation du field", e);
			}
		}
		if (getKeywords() != null) {
			try {
				boost = SearchPropertiesHelper.getBoostMetaKeywords();
				final Field fieldKeys = new Field(KEYWORDS, getKeywords(), Field.Store.YES, Field.Index.ANALYZED);
				fieldKeys.setBoost(boost * 1F);
				document.add(fieldKeys);
			} catch (final Exception e) {
				LOG.error("erreur lors de l'instanciation du field", e);
			}
		}
		if (getUrl() != null) {
			document.add(new Field(URL, getUrl(), Field.Store.YES, Field.Index.NO));
		}
		// Boost par objet
		if (getObjet() != null) {
			document.setBoost(SearchPropertiesHelper.getBoostParObjet("", getObjet().toLowerCase()) * 1F);
		}
		return document;
	}

	/**
	 * Gets the mise en ligne.
	 *
	 * @return the mise en ligne
	 */
	public String getMiseEnLigne() {
		return miseEnLigne;
	}

	/**
	 * Sets the mise en ligne.
	 *
	 * @param miseEnLigne
	 *            the new mise en ligne
	 */
	public void setMiseEnLigne(final String miseEnLigne) {
		this.miseEnLigne = miseEnLigne;
	}

	/**
	 * Gets the content file.
	 *
	 * @return the content file
	 */
	public String getContentFile() {
		return contentFile;
	}

	/**
	 * Sets the content file.
	 *
	 * @param content_file
	 *            the new content file
	 */
	public void setContentFile(final String content_file) {
		this.contentFile = content_file;
	}

	public void setCodeSite(final String codeSite) {
		this.codeSite = codeSite;
	}

	public String getCodeSite() {
		return codeSite;
	}

	public String getCodeRedacteur() {
		return codeRedacteur;
	}

	public void setCodeRedacteur(final String codeRedacteur) {
		this.codeRedacteur = codeRedacteur;
	}
}
