/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jsbsoft.jtf.textsearch;

import com.kportal.core.cluster.ClusterHelper;
import com.kportal.scheduling.spring.quartz.LogReportJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * The Class OptimizerJob.
 */
public class OptimizerJob extends LogReportJob {

    private static final Logger LOG = LoggerFactory.getLogger(OptimizerJob.class);

    public OptimizerJob() {}

    /**
     * Run.
     */
    public void run() {
        try {
            boolean initWriter = false;
            LOG.info("Optimisation de l'index Lucene");
            final Indexer indexer = Indexer.getInstance();
            try {
                // le writer est disponible
                if (indexer.getWriter() == null) {
                    indexer.initWriter();
                    initWriter = true;
                    indexer.optimisation();
                } else {
                    LOG.error("Writer en cours d'exÃ©cution...");
                }
            } catch (final Exception e) {
                LOG.error("Exception lors de l'indexation des fiches : " + e.getMessage(), e);
            } finally {
                if (initWriter) {
                    indexer.closeWriter();
                    ClusterHelper.refresh(Searcher.getInstance(), null);
                }
            }
            LOG.info("Index Lucene optimisÃ©");
        } catch (final Exception e) {
            LOG.error("Exception dans le job d'indexation", e);
        }
    }

    @Override
    public void perform() {
        run();
    }

    @Override
    public String getLogFileName() {
        return OptimizerJob.class.getSimpleName().toLowerCase();
    }
}