/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @author Vincent IBRON
 * 
 */
package com.jsbsoft.jtf.textsearch;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

/**
 * The Class RechercheSiteLocal.
 * 
 * @author malice
 */
public class RechercheSiteLocal implements Recherche {

	/** The lst repertoire recherche. */
	private static Collection<File> lstRepertoireRecherche = null;

	/**
	 * Instantiates a new recherche site local.
	 */
	public RechercheSiteLocal() {
		super();
	}

	/* (non-Javadoc)
	 * @see com.jsbsoft.jtf.textsearch.Recherche#getLstRepertoireRecherche()
	 */
	@Override
	public Collection<File> getLstRepertoireRecherche() {
		if (lstRepertoireRecherche == null) {
			lstRepertoireRecherche = new ArrayList<File>(1);
			lstRepertoireRecherche.add(Indexer.getRepertoireIndexation());
		}
		return lstRepertoireRecherche;
	}
}
