/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jsbsoft.jtf.textsearch.sitesdistants;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

/**
 * Queue thread safe permettant l'ajout et la recuperation de flux HTML a indexer. Visibilité réduite au package.
 * 
 * @author jbiard
 */
class QueueFluxHTML {

	/** The gathered links. */
	Set<String> gatheredLinks;

	/**
	 * Instantiates a new queue flux html.
	 */
	public QueueFluxHTML() {
		gatheredLinks = new HashSet<String>();
		llFluxHTML = new LinkedList<FluxHTML>();
	}

	/**
	 * Gets the taille.
	 * 
	 * @return the taille
	 */
	public int getTaille() {
		return llFluxHTML.size();
	}

	/**
	 * Ajoute une page a indexer.
	 * 
	 * @param szPage
	 *            page sous forme de chaine
	 * @param szUrl
	 *            url correspondant
	 */
	public synchronized void push(String szPage, String szUrl) {
		if (gatheredLinks.add(szUrl)) {
			llFluxHTML.addLast(new FluxHTML(szPage, szUrl));
		}
	}

	/**
	 * Depile un flux a indexer.
	 * 
	 * @return flux
	 */
	public synchronized FluxHTML pop() {
		if (llFluxHTML.size() > 0) {
			return llFluxHTML.removeFirst();
		}
		return null;
	}

	/**
	 * Encapsule le flux et l'url d'une page.
	 * 
	 * @author jbiard
	 * @param <T>
	 */
	public class FluxHTML {

		/**
		 * Gets the page.
		 * 
		 * @return the page
		 */
		public String getPage() {
			return szPage;
		}

		/**
		 * Gets the url.
		 * 
		 * @return the url
		 */
		public String getUrl() {
			return szUrl;
		}

		/**
		 * Instantiates a new flux html.
		 * 
		 * @param szPage
		 *            the sz page
		 * @param szUrl
		 *            the sz url
		 */
		FluxHTML(String szPage, String szUrl) {
			this.szPage = szPage;
			this.szUrl = szUrl;
		}

		/** The sz page. */
		private final String szPage;

		/** The sz url. */
		private final String szUrl;

	}

	/** The ll flux html. */
	private final LinkedList<FluxHTML> llFluxHTML;
}