/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jsbsoft.jtf.textsearch.sitesdistants;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jsbsoft.jtf.textsearch.CibleRecherche;
import com.jsbsoft.jtf.textsearch.Recherche;
import com.jsbsoft.jtf.webutils.ContextePage;
import com.kportal.core.config.PropertyHelper;
import com.univ.objetspartages.om.Site;

/**
 * Singleton prennant en charge la recherche dans les pages indexees des sites distants.
 * 
 * @author jbiard
 */
public class RechercheSitesDistants implements Recherche {

	/** The lst repertoire recherche. */
	private static ArrayList<File> lstRepertoireRecherche = null;

	/** The lst cible. */
	private static Collection<CibleRecherche> lstCible = null;

	private static final Logger LOG = LoggerFactory.getLogger(RechercheSitesDistants.class);

	/**
	 * Gets the lst cible.
	 * 
	 * @return the lst cible
	 * 
	 * @see com.jsbsoft.jtf.textsearch.Recherche#getLstCible()
	 */
	public Collection<CibleRecherche> getLstCible() {
		if (lstCible == null) {
			init();
		}
		return lstCible;
	}

	/* (non-Javadoc)
	 * @see com.jsbsoft.jtf.textsearch.Recherche#getLstRepertoireRecherche()
	 */
	@Override
	public Collection<File> getLstRepertoireRecherche() {
		if (lstRepertoireRecherche == null) {
			init();
		}
		return lstRepertoireRecherche;
	}

	/**
	 * Inits the.
	 */
	public static void init() {
		lstRepertoireRecherche = new ArrayList<File>();
		lstCible = new ArrayList<CibleRecherche>();
		if ("1".equals(PropertyHelper.getCoreProperty("sitesdistants.activation"))) {
			final ContextePage ctx = new ContextePage("");
			try {
				final Site site = new Site();
				site.init();
				site.setCtx(ctx);
				site.select("");
				File fRep = null;
				while (site.nextItem()) {
					lstCible.add(new CibleRecherche(site.getCode(), site.getLibelle()));
					fRep = site.getRepertoireIndexation();
					if (fRep.exists() && fRep.canRead() && fRep.isDirectory()) {
						if (!lstRepertoireRecherche.contains(fRep)) {
							lstRepertoireRecherche.add(fRep);
						}
					}
				}
			} catch (final Exception e) {
				LOG.error("Exception lors de l'interrogation des sites", e);
			} finally {
				ctx.release();
			}
		}
	}

	/**
	 * Gets the cible.
	 * 
	 * @param code
	 *            the code
	 * 
	 * @return the cible
	 */
	public static CibleRecherche getCible(final String code) {
		if (lstCible == null) {
			init();
		}
		final Iterator<CibleRecherche> it = lstCible.iterator();
		CibleRecherche cible = null;
		while (it.hasNext()) {
			cible = it.next();
			if (cible.getCode().equals(code)) {
				return cible;
			}
		}
		return null;
	}
}
