/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jsbsoft.jtf.textsearch.util;

import java.io.File;

import org.apache.commons.lang3.StringUtils;

import com.kportal.core.config.PropertyHelper;
import com.kportal.core.webapp.WebAppUtil;


public class IndexationHelper {

	private static final String PROP_LUCENE_WORKDIR = "lucene.workdir";
	private static final String DEFAULT_LUCENE_WORKDIR = "/WEB-INF/textsearch";

	public static String getWorkDirectory(){
		String res = StringUtils.defaultIfEmpty(PropertyHelper.getCoreProperty(PROP_LUCENE_WORKDIR), WebAppUtil.getAbsolutePath()+DEFAULT_LUCENE_WORKDIR);
		if (StringUtils.isNotEmpty(res) && !(new File(res).exists())) {
			new File(res).mkdir();
		}
		return res;
	}
}
