/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jsbsoft.jtf.textsearch.util;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.search.Query;

import com.kportal.core.config.PropertyHelper;
import com.univ.multisites.InfosSite;
import com.univ.multisites.Site;
import com.univ.utils.Chaine;

public class SearchPropertiesHelper {

	public static final String KEY = "recherche";

	public static final String BOOST_TITRE = "boost_titre";
	public static final String BOOST_METAKEYWORDS = "boost_keywords";
	public static final String BOOST_METADESCRIPTION = "boost_description";
	public static final String BY_SITE = "by_site";
	public static final String BOOST_OBJETS = "boost_objets";
	public static final String BOOST_LIKE = "boost_like";
	public static final String BOOST_OR = "boost_or";
	public static final String BOOST_PHRASE = "boost_phrase";
	public static final String BOOST_AND = "boost_and";
	public static final String BOOST_DATE = "boost_date";
	public static final String LIKE = "like";
	public static final String OR = "or";

	/* Exemple de configuration
	 * 
		recherche.boost_titre=2
		recherche.boost_keywords=4
		recherche.boost_description=2
		recherche.boost_objets=[actualite,2][pagelibre,3][article,2]
		recherche.boost_phrase=4
		recherche.boost_and=2
		recherche.or=1
	 */

	public static boolean executeRechercheLIKE(String aliasSite){
		return "1".equals(getPropertySite(aliasSite,LIKE));
	}

	public static boolean executeRechercheOR(String aliasSite){
		return "1".equals(getPropertySite(aliasSite,OR));
	}

	public static boolean executeRechercheBySite(){
		return "1".equals(getProperty(BY_SITE));
	}

	public static int getBoostRechercheLIKE(String aliasSite){
		return parseBoost(getPropertySite(aliasSite,BOOST_LIKE));
	}

	public static int getBoostRechercheOR(String aliasSite){
		return parseBoost(getPropertySite(aliasSite,BOOST_OR));
	}

	public static int getBoostRecherchePhrase(String aliasSite){
		return parseBoost(getPropertySite(aliasSite,BOOST_PHRASE));
	}

	public static int getBoostRechercheAND(String aliasSite){
		return parseBoost(getPropertySite(aliasSite,BOOST_AND));
	}

	public static int getBoostTitre(){
		return parseBoost(getProperty(BOOST_TITRE));
	}

	public static int getBoostDate(){
		return parseBoost(getProperty(BOOST_DATE));
	}

	public static int getBoostMetaKeywords(){
		return parseBoost(getProperty(BOOST_METAKEYWORDS));
	}

	public static int getBoostMetaDescription(){
		return parseBoost(getProperty(BOOST_METADESCRIPTION));
	}

	public static int getBoostParObjet(String alias,String nomObjet){
		String boost = "";
		List<String> lObjets = null;
		if (StringUtils.isNotEmpty(alias)){
			InfosSite site = Site.renvoyerItemSite(alias);
			lObjets = site.getProprieteComplementaireListString(KEY+"_"+BOOST_OBJETS);
		}
		else{
			lObjets = Chaine.getListCrochets(getProperty(BOOST_OBJETS));
		}
		for (String oBoost : lObjets) {
			if (oBoost.startsWith(nomObjet+",")){
				boost = StringUtils.substringAfter(oBoost, ",");
			}
		}
		return parseBoost(boost);
	}

	public static boolean hasBoostParObjet(String aliasSite){
		return StringUtils.isNotEmpty(getPropertyBoostObjets(aliasSite));
	}

	private static String getPropertyBoostObjets(String aliasSite){
		return getPropertySite(aliasSite,BOOST_OBJETS);
	}

	private static String getPropertySite(String alias, String key){
		if (StringUtils.isEmpty(alias)){
			return getProperty(key);
		}
		InfosSite site = Site.renvoyerItemSite(alias);
		return site.getProprieteComplementaireString(KEY+"_"+key);
	}

	private static String getProperty(String key){
		return PropertyHelper.getCoreProperty(KEY+"."+key);
	}

	private static int parseBoost(String boost){
		int res = 1;
		try{
			res = Integer.parseInt(boost);
		}catch (Exception e) {}
		return res;
	}

	public static void setQueryBoost(Query query,int boost){
		if (boost>1){
			query.setBoost(boost*1F);
		}
	}
}
