/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jsbsoft.jtf.webutils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;

import com.jsbsoft.jtf.core.CodeLibelle;

/**
 * 
 * @author :
 */
public class FormateurHTML {

	/**
	 * Formater date.
	 * 
	 * @param _date
	 *            the _date
	 * @param _locale
	 *            the _locale
	 * 
	 * @return the string
	 */
	public static String FormaterDate(final Date _date, final Locale _locale) {
		final DateFormat date = DateFormat.getDateInstance(DateFormat.LONG, _locale);
		return date.format(_date).toString();
	}

	/**
	 * 
	 * @param table
	 *            Hashtable
	 * @param selected
	 *            the _selected
	 * @param triLibelle
	 *            the tri libelle
	 * 
	 * @return the string
	 */
	public static String insererCombo(final Hashtable<String, String> table, final String selected, final boolean triLibelle) {
		return insererCombo(table, selected, triLibelle, 0);
	}

	/**
	 * 
	 * @param fichier
	 *            the fichier
	 * @param locale
	 *            the _locale
	 * @param selected
	 *            the _selected
	 * @param triLibelle
	 *            the tri libelle
	 * 
	 * @return the string
	 */
	public static String insererComboFichier(final String idCtx, final String fichier, final Locale locale, final String selected, final boolean triLibelle) {
		// triLibelle = true par defaut
		//
		final Hashtable<String, String> table = CodeLibelle.lireTable(idCtx, fichier, locale);
		return insererCombo(table, selected, triLibelle);
	}

	/**
	 * 
	 * @param fichier
	 *            the fichier
	 * @param _locale
	 *            the _locale
	 * @param _cle
	 *            the _cle
	 * 
	 * @return the string
	 */
	public static String insererLibelleFichier(final String idCtx, final String fichier, final Locale _locale, final String _cle) {
		return CodeLibelle.lireLibelle(idCtx, fichier, _locale, _cle);
	}

	/**
	 * Formatage d'une chaine en HTML - conversion des "\n" en <BR>
	 * .
	 * 
	 * @param texte
	 *            the texte
	 * 
	 * @return the string
	 */
	public static String formaterEnHTML(final String texte) {
		final BufferedReader br = new BufferedReader(new StringReader(texte));
		String line = null;
		int iLine = 0;
		final StringBuffer out = new StringBuffer();
		try {
			while ((line = br.readLine()) != null) {
				if (iLine > 0) {
					out.append("<br />");
				}
				out.append(line);
				iLine++;
			}
			// Attention au dernier saut de ligne
			final int lg = texte.length();
			final int lastCar = texte.charAt(lg - 1);
			if (lastCar == 0x0a) {
				out.append("<br />");
			}
			// On ne traite pas le '0d' comme un saut de ligne
			if (lastCar == 0x0d) {
				final char[] end = { 0x0d };
				out.append(end);
			}
			return out.toString();
		} catch (final Exception e) {
			return texte;
		} finally {
			try {
				br.close();
			} catch (final IOException io) {
				return texte;
			}
		}
	}

	/**
	 * Insérez la description de la méthode à cet endroit. Date de création : (26/02/2001 09:45:35)
	 * 
	 * @param table
	 *            Hashtable
	 * @param selected
	 *            the selected
	 * @param triLibelle
	 *            the tri libelle
	 * @param lg
	 *            the lg
	 * 
	 * @return the string
	 */
	public static String insererCombo(final Hashtable<String, String> table, final String selected, final boolean triLibelle, final int lg) {
		String res = "";
		Object cle = null;
		String libelle = null;
		// Tri de la Hashtable
		final SortedMap<Object, Object> sortedMap = new TreeMap<Object, Object>();
		Iterator<Object> it = null;
		if (triLibelle) {
			for (final Enumeration<String> h = table.keys(); h.hasMoreElements();) {
				cle = h.nextElement();
				sortedMap.put(table.get(cle) + "," + cle, cle);
			}
			it = sortedMap.values().iterator();
		} else {
			sortedMap.putAll(table);
			it = sortedMap.keySet().iterator();
		}
		String sSelected = "";
		// Parcours de la map triée
		while (it.hasNext()) {
			cle = it.next();
			libelle = (table.get(cle));
			if (lg > 0 && lg < libelle.length()) {
				libelle = libelle.substring(0, lg);
			}
			sSelected = "";
			if (cle.equals(selected)) {
				sSelected = "selected=\"true\"";
			}
			if (libelle.startsWith("#GROUPE#")) {
				res += "<optgroup id=\"opt" + cle + "\" label=\"" + libelle.substring(8) + "\" >";
			} else if (libelle.startsWith("#/GROUPE#")) {
				res += "</optgroup>";
			} else {
				res += "<option value=\"" + cle + "\" " + sSelected + ">" + libelle + "</option>";
			}
		}
		return res;
	}

	/**
	 * Formatage HTML d'un ensemble de libellés séparés par un ; Les libellés sont séparés par un <BR>
	 * .
	 * 
	 * @param texte
	 *            the texte
	 * 
	 * @return the string
	 */
	public static String formaterLibelleMultipleEnHTML(final String texte) {
		String res = "";
		String line = null;
		final StringTokenizer st = new StringTokenizer(texte, ";");
		int nbItems = 0;
		while (st.hasMoreTokens()) {
			nbItems++;
			if (nbItems > 1) {
				res = res + "<br />";
			}
			line = st.nextToken();
			res = res + line;
		}
		return res;
	}
}
