/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.components.media.tag;

import com.kosmos.components.media.bean.ComponentMediaFile;
import com.kosmos.components.media.bean.ComponentMediaFileList;
import com.kosmos.components.media.bean.ComponentMediaType;
import com.kosmos.components.media.view.model.ComponentMediaViewModel;
import com.kosmos.components.tags.AbstractJspIncludeTag;
import com.kportal.core.config.MessageHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TryCatchFinally;
import java.util.ArrayList;
import java.util.List;

/**
 * Created on 14/11/14.
 */
public class ComponentMediaTag extends AbstractJspIncludeTag implements TryCatchFinally{

    public static final String VIEW_MODEL = "viewModel";
    private String name;

    private ComponentMediaType type;

    private String label;

    private boolean multiple;

    private ComponentMediaFileList medias;

    public ComponentMediaTag() {
        this.path = "/adminsite/components/media/media-component.jsp";
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ComponentMediaType getType() {
        return type;
    }

    public void setType(ComponentMediaType type) {
        this.type = type;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isMultiple() {
        return multiple;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public ComponentMediaFileList getMedias() {
        return medias;
    }

    public void setMedias(ComponentMediaFileList medias) {
        this.medias = medias;
    }

    @Override
    public int doStartTag() throws JspException {
        pageContext.getRequest().setAttribute(VIEW_MODEL, buildModel());
        return super.doStartTag();
    }

    private ComponentMediaViewModel buildModel(){
        final ComponentMediaViewModel viewModel = new ComponentMediaViewModel();
        final List<Long> ids = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(medias)) {
            for (ComponentMediaFile currentComponentMediaFile : medias) {
                ids.add(currentComponentMediaFile.getId());
            }
            viewModel.setMedias(medias);
        }
        viewModel.setIds(String.format("[%s]", StringUtils.join(ids.iterator(), ",")));
        viewModel.setMultiple(multiple);
        viewModel.setName(name);
        viewModel.setType(type);

        final String defaultLabel = multiple ? MessageHelper.getCoreMessage("MEDIA_COMPONENT.LABEL.MULTIPLE") : MessageHelper.getCoreMessage("MEDIA_COMPONENT.LABEL.UNIQUE");
        String finalLabel = StringUtils.isNoneBlank(label) ? MessageHelper.getCoreMessage(label) : defaultLabel;
        if(finalLabel.equals(label)) {
            finalLabel = defaultLabel;
        }
        viewModel.setLabel(finalLabel);
        return viewModel;
    }

    @Override
    public void doCatch(Throwable throwable) throws Throwable {
        throw throwable;
    }

    @Override
    public void doFinally() {
        name = null;
        type = null;
        medias = null;
        label = null;
        multiple = false;
    }
}
