/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.components.media.utils;

import org.apache.commons.lang3.StringUtils;

import com.kosmos.components.media.bean.ComponentMediaFile;
import com.univ.objetspartages.om.Ressource;
import com.univ.utils.ContexteDao;

/**
 * Created by Fabien on 15/11/2014.
 */
public class ComponentMediaFileUtil {

    public static String getDisplayUrl(ComponentMediaFile componentMediaFile) {
        final Ressource ressource = getRessource(componentMediaFile);
        if (ressource != null) {
            if (StringUtils.isNotBlank(ressource.getUrl())) {
                return ressource.getUrl();
            }
        }
        return StringUtils.EMPTY;
    }

    public static Ressource getRessource(ComponentMediaFile componentMediaFile) {
        if(componentMediaFile != null) {
            try (final ContexteDao ctx = new ContexteDao()) {
                final Ressource ressource = new Ressource();
                ressource.setCtx(ctx);
                ressource.setIdRessource(componentMediaFile.getId());
                ressource.retrieve();
                return ressource;
            } catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static String getCodeParent(ComponentMediaFile componentMediaFile) {
        final Ressource ressource = getRessource(componentMediaFile);
        if(ressource != null) {
            return ressource.getCodeParent();
        }
        return null;
    }

}
