/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.layout;

import com.kosmos.layout.card.bean.CardBean;
import com.kosmos.layout.slot.util.SlotList;
import org.codehaus.jackson.annotate.JsonTypeInfo;

import java.util.Collection;

@JsonTypeInfo(use = JsonTypeInfo.Id.CLASS, include = JsonTypeInfo.As.PROPERTY, property = "class")
public abstract interface Layout {

    public abstract SlotList getSlots();

    public abstract Collection<Class<? extends CardBean>> getAllowedCardTypes();

    public abstract Long getId();

    public abstract void setId(Long id);

    public abstract String getName();

    public abstract String getDescription();

    public abstract String getView();

    public abstract String getViewBo();

    public abstract boolean hasContext();
}
