/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.layout.card.bean;

import com.univ.utils.json.Views;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.codehaus.jackson.map.annotate.JsonView;

import java.util.UUID;

@JsonTypeInfo(use = JsonTypeInfo.Id.CLASS, include = JsonTypeInfo.As.PROPERTY, property = "class")
public class CardBean {

    @JsonView({Views.BackOfficeView.class})
    protected Long id;

    @JsonView({Views.BackOfficeView.class})
    protected UUID key;

    @JsonIgnore
    protected String view = "/WEB-INF/jsp/layout/card/fo/view/cardView.jsp";

    @JsonIgnore
    protected String viewBo;

    @JsonIgnore
    protected String editFragment;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public UUID getKey() {
        return key;
    }

    public void setKey(UUID key) {
        this.key = key;
    }

    public String getView() {
        return this.view;
    }

    public void setView(String tileView) {
        this.view = tileView;
    }

    public String getEditFragment() {
        return this.editFragment;
    }

    public String getViewBo() {
        return this.viewBo;
    }
}
