/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.layout.card.bean;

import com.kosmos.components.media.bean.ComponentMediaFile;
import com.kosmos.layout.annotations.MediaContent;
import com.univ.utils.json.Views;
import org.codehaus.jackson.map.annotate.JsonView;

/**
 * Created by fabien.leconte on 12/12/14.
 */
public class PictureCardBean extends SimpleCardBean {

    @JsonView({Views.DaoView.class})
    protected String stylePicture;

    @JsonView({Views.DaoView.class})
    @MediaContent
    protected ComponentMediaFile picture;

    public PictureCardBean() {
        this.view = "/WEB-INF/jsp/layout/card/fo/view/pictureCardView.jsp";
        this.viewBo = "/adminsite/layout/card/bo/view/pictureCardView.jsp";
        this.editFragment = "/adminsite/layout/card/bo/edit/pictureCardEdit.jsp";
    }

    public String getStylePicture() {
        return stylePicture;
    }

    public void setStylePicture(String stylePicture) {
        this.stylePicture = stylePicture;
    }

    public ComponentMediaFile getPicture() {
        return picture;
    }

    public void setPicture(ComponentMediaFile picture) {
        this.picture = picture;
    }

}
