/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.layout.card.bean;

import com.univ.utils.json.Views;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.codehaus.jackson.map.annotate.JsonView;

@JsonTypeInfo(use = JsonTypeInfo.Id.CLASS, include = JsonTypeInfo.As.PROPERTY, property = "class")
public class SimpleCardBean extends CardBean {

    protected static final String DEFAULT_COLOR = "#ffffff";

    @JsonView({Views.DaoView.class})
    protected String title;

    @JsonView({Views.DaoView.class})
    protected String backgroundColor = DEFAULT_COLOR;

    @JsonView({Views.DaoView.class})
    protected String foregroundColor;

    @JsonView({Views.DaoView.class})
    protected String link;

    public SimpleCardBean() {
        this.view = "/WEB-INF/jsp/layout/card/fo/view/simpleCardView.jsp";
        this.viewBo = "/adminsite/layout/card/bo/view/simpleCardView.jsp";
        this.editFragment = "/adminsite/layout/card/bo/edit/simpleCardEdit.jsp";
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backGroundColor) {
        this.backgroundColor = backGroundColor;
    }

    public String getForegroundColor() {
        return foregroundColor;
    }

    public void setForegroundColor(String foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLink() {
        return link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getView() {
        return this.view;
    }

    public void setView(String tileView) {
        this.view = tileView;
    }
}
