/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.layout.card.bean;

import com.kosmos.layout.annotations.ContentTypes;
import com.kosmos.layout.annotations.MediaContent;
import com.univ.utils.json.Views;
import org.codehaus.jackson.map.annotate.JsonView;

public class ToolboxCardBean extends CardBean {

    @JsonView({Views.DaoView.class})
    protected String title;

    @JsonView({Views.DaoView.class})
    protected String styleToolbox;

    @JsonView({Views.DaoView.class})
    @MediaContent(type = ContentTypes.TOOLBOX)
    private String dynamic;

    public ToolboxCardBean() {
        this.view = "/WEB-INF/jsp/layout/card/fo/view/toolboxCardView.jsp";
        this.viewBo = "/adminsite/layout/card/bo/view/toolboxCardView.jsp";
        this.editFragment = "/adminsite/layout/card/bo/edit/toolboxCardEdit.jsp";
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getStyleToolbox() {
        return styleToolbox;
    }

    public void setStyleToolbox(String styleToolbox) {
        this.styleToolbox = styleToolbox;
    }

    public String getDynamic() {
        return this.dynamic;
    }

    public void setDynamic(String dynamic) {
        this.dynamic = dynamic;
    }
}
