/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.layout.card.util;

import com.kosmos.layout.card.bean.SimpleCardBean;
import org.apache.commons.lang3.StringUtils;

/**
 * Created on 30/12/14.
 */
public class SimpleCardUtil {

    public static String computeDynamicStyle(SimpleCardBean card) {
        final String foregroundColor = StringUtils.isNotBlank(card.getForegroundColor()) ? String.format("color: %s;", card.getForegroundColor()) : StringUtils.EMPTY;
        final String backgroundColor = StringUtils.isNotBlank(card.getBackgroundColor()) ? String.format("background-color: %s;", card.getBackgroundColor()) : StringUtils.EMPTY;
        String style = StringUtils.EMPTY;
        if(StringUtils.isNotBlank(foregroundColor) || StringUtils.isNotBlank(backgroundColor)) {
            style = String.format("style=\"%s%s\"", foregroundColor, backgroundColor);
        }
        return style;
    }

}
