/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.layout.card.util;

import com.kosmos.layout.card.bean.ToolboxCardBean;
import com.univ.utils.ContexteUtil;
import com.univ.utils.UnivWebFmt;
import org.apache.commons.lang3.StringUtils;

/**
 * Created by fabien.leconte on 18/11/14.
 */
public class ToolboxCardUtil {

    /**
     * Compute content of a toolbox according to the {@link com.kosmos.layout.card.bean.ToolboxCardBean} passed.
     *
     * @param card
     *         as a {@link com.kosmos.layout.card.bean.ToolboxCardBean}
     * @return the content formated as valid HTML or the original value if any error occured.
     */
    public static String getFormatedContent(ToolboxCardBean card) {
        String processedContent;
        try {
            processedContent = UnivWebFmt.transformerTagsPersonnalisation(ContexteUtil.getContexteUniv(), card.getDynamic());
            processedContent = UnivWebFmt.formaterEnHTML(ContexteUtil.getContexteUniv(), processedContent);
            return StringUtils.removePattern(processedContent, "((http|https)\\://([^/\\:]+)(\\:[0-9]+)*)?/servlet/com\\.univ\\.utils\\.LectureImageToolbox\\?TAG=");
        } catch (Exception e) {
            return card.getDynamic();
        }
    }
}
