/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.layout.content.impl;

import com.kosmos.layout.card.bean.CardBean;
import com.kosmos.layout.content.ContentHandler;
import com.univ.objetspartages.om.FicheUniv;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

/**
 * Created by Fabien on 11/11/2014.
 */
public abstract class AbstractContentHandler<T extends Annotation> implements ContentHandler {

    private Class<T> actualClass;

    public AbstractContentHandler() {
        actualClass = (Class<T>) ((ParameterizedType) getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    @Override
    public void prepareContent(final Map<String, CardBean> inputedModel, final FicheUniv ficheUniv, final Map<String, Object> datas) {
        prepareModelContent(inputedModel, ficheUniv, datas);
        handleSwitch(inputedModel, ficheUniv, datas);
    }

    @Override
    public int handleContent(final Map<String, CardBean> inputedModel, final FicheUniv ficheUniv, final Map<String, Object> datas, final int startIndex) {
        return handleModel(inputedModel, ficheUniv, datas, startIndex);
    }

    protected Collection<Field> getAnnotatedFields(CardBean card) {
        final Collection<Field> annotatedFields = new ArrayList<>();
        final Field[] fields = card.getClass().getDeclaredFields();
        for (Field currentField : fields) {
            if (currentField.isAnnotationPresent(actualClass)) {
                annotatedFields.add(currentField);
            }
        }
        return annotatedFields;
    }

    protected void prepareModelContent(final Map<String, CardBean> inputedModel, final FicheUniv ficheUniv, final Map<String, Object> datas) {
    }

    protected int handleModel(final Map<String, CardBean> inputedModel, final FicheUniv ficheUniv, final Map<String, Object> datas, final int startIndex) {
        return 0;
    }

    protected void handleSwitch(final Map<String, CardBean> inputedModel, final FicheUniv ficheUniv, final Map<String, Object> datas) {
    }

}
