/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.layout.grid.impl;

import com.kosmos.layout.grid.GridLayout;
import com.kosmos.layout.impl.AbstractLayout;
import com.univ.utils.json.Views;
import org.codehaus.jackson.map.annotate.JsonView;

public class AbstractGrid extends AbstractLayout implements GridLayout {

    @JsonView({Views.DaoView.class})
    private int rows;

    @JsonView({Views.DaoView.class})
    private int columns;

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }
}
