/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.layout.grid.managers.impl;

import com.kosmos.layout.grid.GridLayout;
import com.kosmos.layout.grid.managers.GridManager;
import com.kosmos.layout.manager.impl.AbstractLayoutManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

public abstract class AbstractGridManager<T extends GridLayout> extends AbstractLayoutManager<T> implements GridManager<T> {

    public static final Logger LOG = LoggerFactory.getLogger(AbstractGridManager.class);

    public Map<String, T> getAvailableGrids() {
        return this.getLayouts();
    }

    public T getGridByName(String name) {
        return this.getLayouts().get(name);
    }

}
