/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.layout.grid.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.kosmos.layout.exception.DefaultLayoutNotFoundException;
import com.kosmos.layout.exception.GridNotFoundException;
import com.kosmos.layout.exception.LayoutNotFoundException;
import com.kosmos.layout.grid.GridLayout;
import com.kosmos.layout.grid.managers.GridManager;
import com.kosmos.layout.service.ServiceLayout;
import com.univ.objetspartages.om.FicheUniv;

public class ServiceGrid {

    public static final String ID_BEAN = "serviceGrid";

    private ServiceLayout serviceLayout;

    public void setServiceLayout(ServiceLayout serviceLayout) {
        this.serviceLayout = serviceLayout;
    }

    public Collection<GridManager> getGridManagers() {
        return this.serviceLayout.getLayoutManagers(GridManager.class);
    }

    public Map<String, GridLayout> getAvailableGrids() {
        Map<String, GridLayout> availableGrids = new HashMap<>();
        Collection<GridManager> gridManagers = this.serviceLayout.getLayoutManagers(GridManager.class);
        for (GridManager<?> currentGridManager : gridManagers) {
            availableGrids.putAll(currentGridManager.getAvailableGrids());
        }
        return availableGrids;
    }

    public GridLayout getGrid(FicheUniv fiche) throws GridNotFoundException {
        try {
            final GridLayout gridLayout = (GridLayout) serviceLayout.getLayout(fiche);
            if (gridLayout != null) {
                return gridLayout;
            }
        } catch (LayoutNotFoundException | DefaultLayoutNotFoundException e) {
            // TODO : add logs
        }
        return getDefaultGrid(fiche);
    }

    public GridLayout getGrid(String name) throws GridNotFoundException {
        GridLayout foundGrid = null;
        Collection<GridManager> gridManagers = this.serviceLayout.getLayoutManagers(GridManager.class);
        for (GridManager<?> currentGridManager : gridManagers) {
            foundGrid = currentGridManager.getGridByName(name);
            if (foundGrid != null) {
                break;
            }
        }
        if (foundGrid == null) {
            throw new GridNotFoundException(String.format("La grille portant le nom \"%s\" n'a pas été trouvé.", name));
        }
        return foundGrid;
    }

    public GridLayout getDefaultGrid(FicheUniv fiche) throws GridNotFoundException {
        return getDefaultGrid(fiche.getClass().getName());
    }

    public GridLayout getDefaultGrid(String classFiche) throws GridNotFoundException {
        String defaultId = this.serviceLayout.getDefaultLayouts().get(classFiche);
        if (StringUtils.isNotBlank(defaultId)) {
            return getGrid(defaultId);
        }
        throw new GridNotFoundException(String.format("La grille par défaut pour les fiches de type \"%s\" n'a pas été trouvé.", classFiche));
    }
}
