/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.layout.impl;

import com.kosmos.layout.Layout;
import com.kosmos.layout.card.bean.CardBean;
import com.kosmos.layout.slot.util.SlotList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Collection;

public class AbstractLayout implements Layout {

    public static final Logger LOG = LoggerFactory.getLogger(AbstractLayout.class);

    protected boolean context = true;

    protected String viewBo;

    protected String view;

    private SlotList slots;

    private Collection<Class<? extends CardBean>> allowedCardTypes;

    private Long id;

    private String name;

    private String description;

    public String getViewBo() {
        return this.viewBo;
    }

    public void setViewBo(String rendererBo) {
        this.viewBo = rendererBo;
    }

    public String getView() {
        return this.view;
    }

    public void setView(String rendererFo) {
        this.view = rendererFo;
    }

    public void setContext(boolean context) {
        this.context = context;
    }

    public boolean hasContext() {
        return this.context;
    }

    @Override
    public SlotList getSlots() {
        return this.slots;
    }

    public void setSlots(SlotList slots) {
        this.slots = slots;
    }

    @Override
    public Collection<Class<? extends CardBean>> getAllowedCardTypes() {
        return allowedCardTypes;
    }

    public void setAllowedCardTypes(Collection<Class<? extends CardBean>> allowedCardTypes) {
        this.allowedCardTypes = allowedCardTypes;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

}
