/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.layout.plugin;

import java.util.Map;
import java.util.Objects;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.kosmos.layout.Layout;
import com.kosmos.layout.card.bean.CardBean;
import com.kosmos.layout.card.service.ServiceCard;
import com.kosmos.layout.content.ContentHandler;
import com.kosmos.layout.content.manager.ContentHandlerManager;
import com.kosmos.layout.service.ServiceLayout;
import com.kportal.core.context.BeanUtil;
import com.kportal.extension.module.plugin.objetspartages.DefaultPluginFiche;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;
import com.univ.utils.ContexteUtil;

public class LayoutFichePlugin extends DefaultPluginFiche {

    public static final Logger LOG = LoggerFactory.getLogger(LayoutFichePlugin.class);

    private ContentHandlerManager contentHandlerManager;

    private ServiceCard serviceCard;

    private ServiceLayout serviceLayout;

    public void setContentHandlerManager(ContentHandlerManager contentHandlerManager) {
        this.contentHandlerManager = contentHandlerManager;
    }

    public void setServiceCard(ServiceCard serviceCard) {
        this.serviceCard = serviceCard;
    }

    public void setServiceLayout(ServiceLayout serviceLayout) {
        this.serviceLayout = serviceLayout;
    }

    @Override
    public void supprimerObjets(final FicheUniv ficheUniv, final Metatag meta, final String classeObjetCible) throws Exception {
        final Map<String, CardBean> cardModel = serviceCard.getCards(meta.getIdMetatag());
        for (CardBean currentCard : cardModel.values()) {
            serviceCard.deleteCardForMeta(currentCard, meta);
        }
        serviceLayout.deleteLayoutForMeta(meta.getIdMetatag());
    }

    @Override
    public void preparerPrincipal(final Map<String, Object> datas, final FicheUniv ficheUniv, final Metatag meta) throws Exception {
        LayoutFichePluginHelper.prepareBoDatas(datas, ficheUniv);
    }

    @Override
    public void traiterPrincipal(final Map<String, Object> datas, final FicheUniv ficheUniv, final Metatag meta) throws Exception {
        final Long idFiche = Long.valueOf(StringUtils.defaultIfBlank((String) datas.get("ID_FICHE"), "0"));
        final Long layoutId = Long.valueOf(StringUtils.defaultIfBlank((String) datas.get("ID_LAYOUT"), "0"));

        if (layoutId != 0L) {
            // Association du layout à la fiche
            final Layout layout = serviceLayout.getLayout(layoutId);
            serviceLayout.addLayoutForMeta(layout, meta.getIdMetatag());

            // Récupération du modèle saisi
            final boolean resetModelIds = !Objects.equals(ficheUniv.getIdFiche(), idFiche);
            final Map<String, CardBean> inputedModel = LayoutFichePluginHelper.retrieveModelFromDatas(datas, layout, resetModelIds);

            // Nettoyage du modèle eventuellement présent par rapport au modèle saisi
            try {
                serviceCard.cleanUpModel(ficheUniv, inputedModel);
            } catch (Exception e) {
                LOG.warn("An error occurred trying to clean up recorded model.", e);
            }

            // Sauvegarde du modèle et des références vers la fiche
            handleContent(inputedModel, ficheUniv, datas);
            for (Map.Entry<String, CardBean> currentEntry : inputedModel.entrySet()) {
                // Prise en charge du contenu à partir des "ContentHandler" définis
                serviceCard.addCardForMeta(currentEntry.getValue(), meta);
            }
        }
    }

    private void handleContent(Map<String, CardBean> inputedModel, FicheUniv ficheUniv, Map<String, Object> datas) {
        int startIndex = 0;
        for (ContentHandler currentHandler : contentHandlerManager.getContentHandlers()) {
            startIndex += currentHandler.handleContent(inputedModel, ficheUniv, datas, startIndex);
        }
    }

    @Override
    public void setDataContexteUniv(final FicheUniv ficheUniv, final Metatag meta, final String classeObjet) throws Exception {
        LayoutFichePluginHelper.prepareFoDatas(ContexteUtil.getContexteUniv().getDatas(), ficheUniv);
    }

    @Override
    public Object getDataContexteUniv() {
        return ContexteUtil.getContexteUniv().getData(BeanUtil.getBeanKey(getId(), getIdExtension()));
    }

}
