/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.layout.plugin;

import java.util.List;
import java.util.Map;

import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kosmos.layout.card.service.ServiceCard;
import com.kportal.core.config.MessageHelper;
import com.kportal.extension.module.plugin.objetspartages.DefaultPluginSaisieFiche;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by fabien.leconte on 13/11/14.
 */
public class LayoutSaisieFichePlugin extends DefaultPluginSaisieFiche {

    public static final Logger LOG = LoggerFactory.getLogger(ServiceCard.class);

    private List<String> classes;

    public List<String> getClasses() {
        return classes;
    }

    public void setClasses(final List<String> classes) {
        this.classes = classes;
    }

    @Override
    public void traiterAction(final Map<String, Object> datas, final FicheUniv ficheUniv, Metatag meta) throws Exception {
        if (isActive(ficheUniv.getClass().getName())) {
            final String action = (String) datas.get("ACTION");
            if ("CHANGER_LAYOUT".equals(action)) {
                changeLayout(datas, ficheUniv);
            } else if("ONGLET".equals(action)) {
                final Long layoutId = StringUtils.isNumeric((String) datas.get("ID_LAYOUT")) ? Long.parseLong((String) datas.get("ID_LAYOUT")) : null;
                if(layoutId != null) {
                    LayoutFichePluginHelper.propagateInputedModel(datas, layoutId);
                }
            }
        }
    }

    private void changeLayout(Map<String, Object> datas, FicheUniv ficheUniv) throws Exception {
        final Long idFiche = new Long((String) datas.get("ID_FICHE"));
        if (idFiche != 0) {
            try {
                ficheUniv.setIdFiche(idFiche);
                ficheUniv.retrieve();
            } catch (final Exception e) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_FICHE_INEXISTANTE"));
            }
        }
        final Long layoutId = Long.valueOf(StringUtils.defaultIfBlank((String) datas.get("ID_LAYOUT"), "0"));
        LayoutFichePluginHelper.prepareBoDatas(datas, ficheUniv, layoutId);
    }

    public boolean isActive(final String classe) {
        if (classes == null) {
            return Boolean.TRUE;
        } else {
            if (classes.contains(classe)) {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }
}
