/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.layout.slot.impl;

import com.kosmos.layout.card.bean.CardBean;
import com.kosmos.layout.slot.Slot;
import com.kosmos.layout.slot.util.SlotState;
import com.univ.utils.json.Views;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.codehaus.jackson.map.annotate.JsonView;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;

/**
 * Created by fabien.leconte on 08/12/14.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CLASS, include = JsonTypeInfo.As.PROPERTY, property = "class")
public class BaseSlot implements Slot {

    @JsonIgnore
    protected String view;

    @JsonIgnore
    protected String viewBo;

    @JsonView({Views.DaoView.class})
    private Collection<Class<? extends CardBean>> allowedCardTypes;

    @JsonView({Views.DaoView.class})
    private UUID key;

    @JsonView({Views.DaoView.class})
    private SlotState state = SlotState.EMPTY;

    public BaseSlot() {
        allowedCardTypes = new ArrayList<>();
        viewBo = "/adminsite/layout/slot/bo/view/slotView.jsp";
        view = "/WEB-INF/jsp/layout/slot/fo/view/slotView.jsp";
    }

    @Override
    public Collection<Class<? extends CardBean>> getAllowedCardTypes() {
        return allowedCardTypes;
    }

    public void setAllowedCardTypes(Collection<Class<? extends CardBean>> allowedCardTypes) {
        this.allowedCardTypes = allowedCardTypes;
    }

    @Override
    public UUID getKey() {
        return key;
    }

    public void setKey(UUID key) {
        this.key = key;
    }

    @Override
    public SlotState getState() {
        return state;
    }

    @Override
    public void setState(SlotState state) {
        this.state = state;
    }

    @Override
    public String getView() {
        return view;
    }

    @Override
    public String getViewBo() {
        return viewBo;
    }
}
