/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.layout.slot.tag;

import com.kosmos.layout.plugin.LayoutFichePluginHelper;
import com.kosmos.layout.slot.view.model.SlotViewModel;
import com.kosmos.layout.tag.AbstractLayoutTag;

import javax.servlet.jsp.JspException;

public class SlotTag extends AbstractLayoutTag<SlotViewModel> {

    public SlotTag() {
        retrieveKey = LayoutFichePluginHelper.SLOT_VIEW_MODEL;
    }

    @Override
    public int doStartTag() throws JspException {
        super.doStartTag();
        includeJSP(front ? viewModel.getSlot().getView() : viewModel.getSlot().getViewBo());
        return 0;
    }
}
