/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.layout.slot.util;

import com.kosmos.layout.grid.GridLayout;
import com.kosmos.layout.slot.Slot;
import com.kosmos.layout.slot.impl.GridSlot;
import org.apache.commons.lang3.StringUtils;

/**
 * Created by fabien.leconte on 08/12/14.
 */
public class GridSlotUtil {

    public static String getSlotKey(GridLayout grid, int row, int column) {
        for (Slot currentSlot : grid.getSlots()) {
            final GridSlot gridSlot = (GridSlot) currentSlot;
            if (gridSlot.getRow() == row && gridSlot.getColumn() == column) {
                return gridSlot.getKey().toString();
            }
        }
        return null;
    }

    public static String getClassName(GridSlot gridSlot) {
        if (gridSlot != null) {
            final String classColSpan = gridSlot.getColSpan() > 1 ? String.format("layout__slot--columnspan%d", gridSlot.getColSpan()) : StringUtils.EMPTY;
            final String classRowSpan = gridSlot.getRowSpan() > 1 ? String.format("layout__slot--rowspan%d", gridSlot.getRowSpan()) : StringUtils.EMPTY;
            final String position = String.format("layout__slot--%dx%d", gridSlot.getRow(), gridSlot.getColumn());
            return String.format("%s %s %s", classColSpan, classRowSpan, position);
        }
        return StringUtils.EMPTY;
    }
}
