/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.plansite.module;

import org.apache.commons.lang3.StringUtils;

import com.kosmos.plansite.PlanSite;
import com.kportal.tag.interpreteur.impl.AbstractInterpreteurTag;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.Rubrique;
import com.univ.utils.ContexteUtil;

public class InterpreteurTag extends AbstractInterpreteurTag {

	@Override
	public String interpreterTag(final String texteAInterpreter, final String baliseOuvrante, final String baliseFermante) throws Exception {
		// test que le tag est genere pour une jsp en front
		if (ContexteUtil.getContexteUniv().getJspWriter() != null) {
			final String param = StringUtils.substringBetween(texteAInterpreter, baliseOuvrante, baliseFermante);
			int indRubrique = param.indexOf("CODE_RUBRIQUE");
			int indNiveau = param.indexOf("NB_NIVEAUX");
			String codeRubriqueMere = "";
			if (indRubrique != -1) {
				indRubrique += 14;
				if (indRubrique < indNiveau) {
					codeRubriqueMere = param.substring(indRubrique, param.indexOf(";", indRubrique));
				} else {
					codeRubriqueMere = param.substring(indRubrique);
				}
			}
			int niveauMax = 0;
			if (indNiveau != -1) {
				indNiveau += 11;
				if (indNiveau < indRubrique) {
					niveauMax = Integer.parseInt(param.substring(indNiveau, param.indexOf(";", indNiveau)));
				} else {
					niveauMax = Integer.parseInt(param.substring(indNiveau));
				}
			}
			final InfosRubriques topRubrique = Rubrique.renvoyerItemRubrique(codeRubriqueMere);
			final PlanSite planSite = new PlanSite(ContexteUtil.getContexteUniv(), topRubrique, niveauMax);
			return ("<div class=\"plan-site\">" + planSite.getPlan() + "</div><!-- .plan-site -->");
		}
		return StringUtils.EMPTY;
	}

	@Override
	public String getReferenceTag(final String texteAInterpreter, final String baliseOuvrante, final String baliseFermante) {
		// TODO Auto-generated method stub
		return null;
	}
}
