/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.registration.action.history;

import java.util.Date;

import com.kosmos.registration.bean.RegistrationState;
import org.codehaus.jackson.annotate.JsonTypeInfo;

/**
 * Created on 24/12/14.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CLASS, include = JsonTypeInfo.As.PROPERTY, property = "class")
public class ActionHistory {

    private Date creationDate;

    private String creationIdentity;

    private RegistrationState state;

    public Date getCreationDate() {
        return creationDate;
    }

    public void setCreationDate(final Date creationDate) {
        this.creationDate = creationDate;
    }

    public String getCreationIdentity() {
        return creationIdentity;
    }

    public void setCreationId(final String creationIdentity) {
        this.creationIdentity = creationIdentity;
    }

    public RegistrationState getState() {
        return state;
    }

    public void setState(final RegistrationState state) {
        this.state = state;
    }

}
