/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.registration.bean;

import com.kosmos.registration.action.ActionConfiguration;
import org.codehaus.jackson.annotate.JsonTypeInfo;

import java.util.Map;

/**
 * Created on 24/12/14.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CLASS, include = JsonTypeInfo.As.PROPERTY, property = "class")
public class Model {

    private Long id;

    private String modelDescriptorId;

    private Map<String, ? extends ActionConfiguration> actionConfigurationById;

    public String getModelDescriptorId() {
        return modelDescriptorId;
    }

    public void setModelDescriptorId(String modelDescriptorId) {
        this.modelDescriptorId = modelDescriptorId;
    }

    public Map<String, ? extends ActionConfiguration> getActionConfigurationById() {
        return actionConfigurationById;
    }

    public void setActionConfigurationById(Map<String, ? extends ActionConfiguration> actionConfigurationById) {
        this.actionConfigurationById = actionConfigurationById;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}
