/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.registration.bean;

import java.util.Date;
import java.util.List;
import java.util.Map;

import com.kosmos.registration.action.history.ActionHistory;
import org.apache.commons.lang3.tuple.Pair;

/**
 * Bean contenant les données d'une inscription. Elle contient l'état de l'inscription (validé, modéré, terminé...)
 * ainsi que toute les données saisies.
 */
public class Registration {

    private Long id;

    private Long modelId;

    private Map<String, RegistrationData> dataByAction;

    private List<Pair<String, ActionHistory>> actionHistory;

    private RegistrationState state;

    private String creationIdentity;

    private Date creationDate;

    private String lastUpdateIdentity;

    private Date lastUpdateDate;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getModelId() {
        return modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public List<Pair<String, ActionHistory>> getActionHistory() {
        return actionHistory;
    }

    public void setActionHistory(List<Pair<String, ActionHistory>> actionHistory) {
        this.actionHistory = actionHistory;
    }

    public RegistrationState getState() {
        return state;
    }

    public void setState(RegistrationState state) {
        this.state = state;
    }

    public String getCreationIdentity() {
        return creationIdentity;
    }

    public void setCreationIdentity(String creationIdentity) {
        this.creationIdentity = creationIdentity;
    }

    public Date getCreationDate() {
        return creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getLastUpdateDate() {
        return lastUpdateDate;
    }

    public void setLastUpdateDate(Date lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
    }

    public String getLastUpdateIdentity() {
        return lastUpdateIdentity;
    }

    public void setLastUpdateIdentity(String lastUpdateIdentity) {
        this.lastUpdateIdentity = lastUpdateIdentity;
    }

    public Map<String, RegistrationData> getDataByAction() {
        return dataByAction;
    }

    public void setDataByAction(Map<String, RegistrationData> dataByAction) {
        this.dataByAction = dataByAction;
    }
}
