/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.registration.dao;

import com.jsbsoft.jtf.datasource.dao.CommonDAO;
import com.jsbsoft.jtf.datasource.exceptions.DataSourceException;
import com.kosmos.registration.bean.Registration;
import com.kosmos.registration.bean.RegistrationState;

import java.util.Collection;

/**
 * DAO permettant de persister les données d'une inscription
 */
public interface RegistrationDao extends CommonDAO<Registration> {

    public Collection<Registration> getByModel(Long modelId) throws DataSourceException;

    public Collection<Registration> getByModelAndState(Long modelId, RegistrationState state) throws DataSourceException;

    public void deleteByModelId(Long modelId);
}