/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.registration.exception;

import com.jsbsoft.jtf.core.ApplicationContextManager;

/**
 * Exception permettant de gérer les Exceptions de
 */
public abstract class RegistrationException extends Exception {

    private String extensionId;

    public RegistrationException(String message, String extensionId) {
        super(message);
        this.extensionId = extensionId;
    }

    public RegistrationException(String message, String extensionId, Throwable cause) {
        super(message, cause);
        this.extensionId = extensionId;
    }
    public RegistrationException(String message) {
        super(message);
        this.extensionId = ApplicationContextManager.DEFAULT_CORE_CONTEXT;
    }

    public RegistrationException(String message, Throwable cause) {
        super(message, cause);
        this.extensionId = ApplicationContextManager.DEFAULT_CORE_CONTEXT;
    }

    public String getExtensionId() {
        return extensionId;
    }

    public void setExtensionId(String extensionId) {
        this.extensionId = extensionId;
    }
}
