/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.registration.exception;

import javax.validation.ConstraintViolation;
import java.util.HashSet;
import java.util.Set;

/**
 * Created by olivier.camon on 09/01/15.
 */
public class RegistrationViolationValidationException extends RegistrationValidationException {

    private Set<ConstraintViolation<?>> constraintViolations = new HashSet<>();

    public RegistrationViolationValidationException(String message) {
        super(message);
    }

    public RegistrationViolationValidationException(String message, String extensionId) {
        super(message,extensionId);
    }

    public RegistrationViolationValidationException(String message, String extensionId, Throwable cause) {
        super(message, extensionId, cause);
    }

    public RegistrationViolationValidationException(String message, Throwable cause) {
        super(message, cause);
    }

    public RegistrationViolationValidationException(String mes, Set<? extends ConstraintViolation<?>> constraintViolations) {
        super(mes);
        this.constraintViolations = new HashSet<>(constraintViolations);
    }

    public RegistrationViolationValidationException(String mes, String extensionId, Set<? extends ConstraintViolation<?>> constraintViolations) {
        super(mes,extensionId);
        this.constraintViolations = new HashSet<>(constraintViolations);
    }

    public Set<ConstraintViolation<?>> getConstraintViolations() {
        return constraintViolations;
    }

}
