/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.registration.service.impl;

import java.util.Collection;

import com.kosmos.registration.bean.Model;
import com.kosmos.registration.dao.ModelDao;
import com.kosmos.registration.exception.RegistrationModelNotFoundException;

/**
 * Created on 24/12/14.
 */
public class ModelService {

    public static final String ID_BEAN = "modelService";

    private ModelDao modelDao;

    public void setModelDao(ModelDao modelDao) {
        this.modelDao = modelDao;
    }

    public Model get(final Long id) throws RegistrationModelNotFoundException {
        final Model model = modelDao.getById(id);
        if (model == null) {
            throw new RegistrationModelNotFoundException(String.format("Le modèle portant l'id \"%d\" n'a pas été trouvé.", id));
        }
        return model;
    }

    public Model create(Model model) {
        return modelDao.add(model);
    }

    public Model update(Model model) {
        return modelDao.update(model);
    }

    public Collection<Model> getByModelDescriptorID(String modelDescriptorId) {
        return modelDao.getModelByDescriptorID(modelDescriptorId);
    }

    public void delete(Long modelId) {
        modelDao.delete(modelId);
    }
}
