/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.userfront.bean;

import org.hibernate.validator.constraints.Email;

import com.kosmos.registration.bean.RegistrationData;
import com.kosmos.validation.constraint.NotNullNorEmpty;

/**
 * Bean contenant toute les infos permettant d'envoyer un email de confirmation
 */
public class EmailRegistrationData implements RegistrationData {

	@Email
	@NotNullNorEmpty
	private String email;

	@NotNullNorEmpty
	private String idLocaleKportal;

	@NotNullNorEmpty
	private String processus;

	@NotNullNorEmpty
	private String extension;

	@NotNullNorEmpty
	private String aliasSite;

	private String generatedKey;

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getGeneratedKey() {
		return generatedKey;
	}

	public void setGeneratedKey(String generatedKey) {
		this.generatedKey = generatedKey;
	}

	public String getIdLocaleKportal() {
		return idLocaleKportal;
	}

	public void setIdLocaleKportal(String idLocaleKportal) {
		this.idLocaleKportal = idLocaleKportal;
	}

	public String getProcessus() {
		return processus;
	}

	public void setProcessus(String processus) {
		this.processus = processus;
	}

	public String getExtension() {
		return extension;
	}

	public void setExtension(String extension) {
		this.extension = extension;
	}

	public String getAliasSite() {
		return aliasSite;
	}

	public void setAliasSite(String aliasSite) {
		this.aliasSite = aliasSite;
	}
}
