/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.userfront.bean;

import java.util.Date;

import com.kosmos.registration.bean.RegistrationData;
import com.kosmos.validation.constraint.NotNullNorEmpty;

/**
 * Bean contenant les informations permettant de gérer la modération. Il contient l'ensemble des informations de l'utilisateur (sauf le mdp heureusement).
 */
public class UserModerationData implements RegistrationData {

	private Long id;

	@NotNullNorEmpty
	private String email;

	@NotNullNorEmpty
	private String login;

	private String firstName;

	private String lastName;

	private String idLocaleKportal;

	private String aliasSite;

	private ModerationState moderationState;

	private String moderationMessage;

	private Date creationDate;

	private Long parentIdRegistration;

	public String getModerationMessage() {
		return moderationMessage;
	}

	public void setModerationMessage(String moderationMessage) {
		this.moderationMessage = moderationMessage;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Date getCreationDate() {
		return creationDate;
	}

	public void setCreationDate(Date creationDate) {
		this.creationDate = creationDate;
	}

	public ModerationState getModerationState() {
		return moderationState;
	}

	public void setModerationState(ModerationState moderationState) {
		this.moderationState = moderationState;
	}

	public Long getParentIdRegistration() {
		return parentIdRegistration;
	}

	public void setParentIdRegistration(Long parentIdRegistration) {
		this.parentIdRegistration = parentIdRegistration;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getLogin() {
		return login;
	}

	public void setLogin(String login) {
		this.login = login;
	}

	public String getIdLocaleKportal() {
		return idLocaleKportal;
	}

	public void setIdLocaleKportal(String idLocaleKportal) {
		this.idLocaleKportal = idLocaleKportal;
	}

	public String getAliasSite() {
		return aliasSite;
	}

	public void setAliasSite(String aliasSite) {
		this.aliasSite = aliasSite;
	}

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}
}
