/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.userfront.bean;

import java.util.Date;

import javax.validation.constraints.Size;

import org.hibernate.validator.constraints.Email;

import com.kosmos.registration.bean.RegistrationData;
import com.kosmos.userfront.validation.constraint.PasswordConfirmation;
import com.kosmos.validation.constraint.NotNullNorEmpty;
import com.kosmos.validation.constraint.PasswordSize;

/**
 * Bean contenant les informations permettant de créer un utilisateur kportal ainsi que les contraintes nécessaire.
 */
@PasswordConfirmation
public class UserRegistrationData implements RegistrationData {

	@Size(max = 64)
	@NotNullNorEmpty
	private String login;

	@NotNullNorEmpty
	@Size(max = 255)
	private String firstName;

	@NotNullNorEmpty
	@Size(max = 255)
	private String lastName;

	@Email
	@NotNullNorEmpty
	@Size(max = 255)
	private String email;

	@PasswordSize
	private String password;

	private String passwordConfirmation;

	private String idLocaleKportal;

	private String aliasSite;

	private Date birthdate;

	private String ldapCode;

	private String groups;

	private String validationRestriction;

	private String EditionExtension;

	private String title;

	private String institutionsCodes;

	private String interests;

	private String profiles;

	private String dsiGroups;

	private String dsiGroupsFromImport;

	private String roles;

	private String defaultProfile;

	private String mailFormat;

	private String expertMode;

	public String getFirstName() {
		return firstName;
	}

	public Date getBirthdate() {
		return birthdate;
	}

	public void setBirthdate(Date birthdate) {
		this.birthdate = birthdate;
	}

	public String getLdapCode() {
		return ldapCode;
	}

	public void setLdapCode(String ldapCode) {
		this.ldapCode = ldapCode;
	}

	public String getGroups() {
		return groups;
	}

	public void setGroups(String groups) {
		this.groups = groups;
	}

	public String getValidationRestriction() {
		return validationRestriction;
	}

	public void setValidationRestriction(String validationRestriction) {
		this.validationRestriction = validationRestriction;
	}

	public String getEditionExtension() {
		return EditionExtension;
	}

	public void setEditionExtension(String editionExtension) {
		EditionExtension = editionExtension;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getInstitutionsCodes() {
		return institutionsCodes;
	}

	public void setInstitutionsCodes(String institutionsCodes) {
		this.institutionsCodes = institutionsCodes;
	}

	public String getInterests() {
		return interests;
	}

	public void setInterests(String interests) {
		this.interests = interests;
	}

	public String getProfiles() {
		return profiles;
	}

	public void setProfiles(String profiles) {
		this.profiles = profiles;
	}

	public String getDsiGroups() {
		return dsiGroups;
	}

	public void setDsiGroups(String dsiGroups) {
		this.dsiGroups = dsiGroups;
	}

	public String getDsiGroupsFromImport() {
		return dsiGroupsFromImport;
	}

	public void setDsiGroupsFromImport(String dsiGroupsFromImport) {
		this.dsiGroupsFromImport = dsiGroupsFromImport;
	}

	public String getRoles() {
		return roles;
	}

	public void setRoles(String roles) {
		this.roles = roles;
	}

	public String getDefaultProfile() {
		return defaultProfile;
	}

	public void setDefaultProfile(String defaultProfile) {
		this.defaultProfile = defaultProfile;
	}

	public String getMailFormat() {
		return mailFormat;
	}

	public void setMailFormat(String mailFormat) {
		this.mailFormat = mailFormat;
	}

	public String getExpertMode() {
		return expertMode;
	}

	public void setExpertMode(String expertMode) {
		this.expertMode = expertMode;
	}

	public String getLogin() {
		return login;
	}

	public void setLogin(String login) {
		this.login = login;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getPasswordConfirmation() {
		return passwordConfirmation;
	}

	public void setPasswordConfirmation(String passwordConfirmation) {
		this.passwordConfirmation = passwordConfirmation;
	}

	public String getIdLocaleKportal() {
		return idLocaleKportal;
	}

	public void setIdLocaleKportal(String idLocaleKportal) {
		this.idLocaleKportal = idLocaleKportal;
	}

	public String getName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getAliasSite() {
		return aliasSite;
	}

	public void setAliasSite(String aliasSite) {
		this.aliasSite = aliasSite;
	}
}
