/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.userfront.extension.utils;

import java.util.Arrays;
import java.util.Collection;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kportal.core.autorisation.util.PermissionUtil;
import com.kportal.extension.module.IModule;
import com.kportal.extension.module.ModuleHelper;
import com.univ.objetspartages.om.PermissionBean;

/**
 * Created by olivier.camon on 19/01/15.
 */
public class UserFrontUtils {

	public static final String ID_BEAN = "userFront";

	/**
	 * La permission permettant de modifier des sites
	 */
	public static final String CODE_ACTION_MODIFICATION = "M";

	public static final String CODE_PERMISSION = "userCreation";

	/**
	 * La permission permettant de gérer les sites (Create Update Delete)
	 */
	public static final String CODE_ACTION_GESTION = "G";

	/**
	 * Les actions possible avec les droits de modification (lister & modifier)
	 */
	public static final Collection<String> ACTIONS_MODIFICATION = Arrays.asList("MODIFIER", "ACCUEIL", "LISTE", "VALIDER_MODIFICATION");

	public static IModule getModule() {
		return ModuleHelper.getModule(ApplicationContextManager.DEFAULT_CORE_CONTEXT, ID_BEAN);
	}

	/**
	 * Retourne la permission de gestion des sites.
	 */
	public static PermissionBean getPermissionGestion() {
		return PermissionUtil.getPermissionBean(getModule(), CODE_PERMISSION, CODE_ACTION_GESTION);
	}

	/**
	 * Retourne la permission de modification des sites.
	 */
	public static PermissionBean getPermissionModification() {
		return PermissionUtil.getPermissionBean(getModule(), CODE_PERMISSION, CODE_ACTION_MODIFICATION);
	}
}
