/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.userfront.module;

import java.util.Collection;
import java.util.HashMap;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.core.ProcessusHelper;
import com.kosmos.registration.action.bean.EmptyActionConfiguration;
import com.kosmos.registration.bean.Model;
import com.kosmos.registration.bean.ModelDescriptor;
import com.kosmos.registration.service.impl.ModelService;
import com.kportal.core.autorisation.util.PermissionUtil;
import com.kportal.extension.module.DefaultModuleImpl;
import com.kportal.extension.module.IModule;
import com.kportal.extension.module.ModuleHelper;
import com.univ.objetspartages.om.PermissionBean;


public class UserFrontModule extends DefaultModuleImpl {

	private static final String ID_BEAN = "userFrontModule";

	public static final String ID_MODEL_DESCRIPTOR_USER_CREATION = "userCreationDescription";


	public static final String MANAGEMENT_ACTION_CODE = "G";

	/**
	 * La permission permettant de gérer les créations de compte en front
	 */
	public static final String CODE_PERMISSION = "userFront";

	public static IModule getModule() {
		return ModuleHelper.getModule(ApplicationContextManager.DEFAULT_CORE_CONTEXT, ID_BEAN);
	}

	public static boolean isActiveModule() {
		return getModule() != null && IModule.ETAT_ACTIF == getModule().getEtat() && ApplicationContextManager.getCoreContextBean(ID_MODEL_DESCRIPTOR_USER_CREATION) != null;
	}

	/**
	 * Retourne la permission de gestion des sites.
	 */
	public static PermissionBean getPermissionGestion() {
		return PermissionUtil.getPermissionBean(getModule(), CODE_PERMISSION, MANAGEMENT_ACTION_CODE);
	}

	public static String getUrlUserRegistrationFront() {
		String result = StringUtils.EMPTY;
		if (isActiveModule()) {
			result = ProcessusHelper.getUrlProcessAction(null, ApplicationContextManager.DEFAULT_CORE_CONTEXT, "USERFRONT_FRONT", "CREATION",null);
		}
		return result;
	}

	public static long getIdModelUserCreation() {
		ModelDescriptor descriptorAccount = ApplicationContextManager.getCoreContextBean(ID_MODEL_DESCRIPTOR_USER_CREATION, ModelDescriptor.class);
		ModelService modelService = ApplicationContextManager.getCoreContextBean(ModelService.ID_BEAN, ModelService.class);
		Collection<Model> modelsByDescriptor = modelService.getByModelDescriptorID(descriptorAccount.getId());
		Long idModel;
		if (CollectionUtils.isNotEmpty(modelsByDescriptor)) {
			idModel = modelsByDescriptor.iterator().next().getId();
		} else {
			Model myModel = new Model();
			myModel.setModelDescriptorId(descriptorAccount.getId());
			myModel.setActionConfigurationById(new HashMap<String, EmptyActionConfiguration>());
			modelService.create(myModel);
			idModel = myModel.getId();
		}
		return idModel;
	}

}
