/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.userfront.service;

import java.util.List;

import com.jsbsoft.jtf.datasource.exceptions.DataSourceException;
import com.kosmos.userfront.bean.UserModerationData;
import com.kosmos.userfront.dao.UserModerationDao;

/**
 * Created by olivier.camon on 16/01/15.
 */
public class UserModerationService {

	public static final String ID_BEAN = "userModerationService";

	private UserModerationDao dao;

	public UserModerationData get(Long id) throws DataSourceException {
		return dao.getById(id);
	}

	public UserModerationData create(UserModerationData data) {
		return dao.add(data);
	}

	public UserModerationData update(UserModerationData data) {
		return dao.update(data);
	}

	public List<UserModerationData> getAllUserModerationOrderByCreation() {
		return dao.selectAllOrderByCreattionDate();
	}

	public void setDao(UserModerationDao dao) {
		this.dao = dao;
	}
}
