/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.usinesite.exception;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kosmos.usinesite.template.bean.TemplateSite;
import com.univ.multisites.InfosSite;

/**
 * Exception qui peut contenir plusieurs messages d'erreur.
 * 
 * @author pierre.cosson
 * 
 */
public class ErreursSaisieInfosSite extends ErreurApplicative {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	public static final String SEPARATEUR_MESSAGE = ";";

	/**
	 * Liste des messages d'erreur contenus dans l'application.
	 */
	private List<String> listeMessagesErreur = new ArrayList<String>();

	private InfosSite infosSiteOrigineErreurs = null;
	private TemplateSite templateInfossiteOrigineErreurs = null;

	/**
	 * Constructeur simple. A utiliser lorsqu'il y a qu'une seule erreur.
	 * 
	 * @param mes
	 */
	public ErreursSaisieInfosSite(String mes) {
		super(mes);
		listeMessagesErreur = new ArrayList<String>(1);
		listeMessagesErreur.add(mes);
	}

	public ErreursSaisieInfosSite(String mes, InfosSite infosSiteOrigineErreurs, TemplateSite templateInfossiteOrigineErreurs) {
		this(mes);
		this.infosSiteOrigineErreurs = infosSiteOrigineErreurs;
		this.templateInfossiteOrigineErreurs = templateInfossiteOrigineErreurs;
	}

	/**
	 * Construire l'exception avec une liste de messages d'erreur. <br/>
	 * Lors d'un {@link #getMessage()} la liste des erreurs sera séparé par
	 * {@link #SEPARATEUR_MESSAGE}.
	 * 
	 * @param messagesErreur
	 */
	public ErreursSaisieInfosSite(List<String> messagesErreur, InfosSite infosSiteOrigineErreurs,
			TemplateSite templateInfossiteOrigineErreurs) {
		super(StringUtils.join(messagesErreur, SEPARATEUR_MESSAGE));
		listeMessagesErreur = messagesErreur;
		this.infosSiteOrigineErreurs = infosSiteOrigineErreurs;
		this.templateInfossiteOrigineErreurs = templateInfossiteOrigineErreurs;
	}

	/**
	 * Récuéprer la liste des messages d'ereur.
	 * 
	 * @return La liste des messages d'erreur. Cette liste contient au minimum
	 *         un message d'erreur.
	 */
	public List<String> getListeMessagesErreur() {
		return listeMessagesErreur;
	}

	public InfosSite getInfosSiteOrigineErreurs() {
		return infosSiteOrigineErreurs;
	}

	public TemplateSite getTemplateInfossiteOrigineErreurs() {
		return templateInfossiteOrigineErreurs;
	}

}
