/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.usinesite.migration.bean;

import java.util.Collections;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;

import com.univ.utils.json.CodecJSon;

public class ProprietesSite {

	public int sslMode = 0;

	public int boSslMode = 0;

	public int restriction = 0;

	public int modeReecritureRubrique = 0;

	public int niveauMaxReecritureRubrique = 0;

	public int niveauMinReecritureRubrique = 0;

	public boolean sso = Boolean.FALSE;

	public boolean sitePrincipal = Boolean.FALSE;

	public String urlAccueil = StringUtils.EMPTY;

	public Set<Integer> httpActions = Collections.<Integer> emptySet();

	public Set<Integer> httpsActions = Collections.<Integer> emptySet();

	public Set<String> listeHostAlias = Collections.<String> emptySet();

	@Override
	public String toString() {
		String retour = StringUtils.EMPTY;
		try {
			retour = CodecJSon.encodeObjectToJSonInString(this);
		} catch (final Exception e) {}
		return retour;
	}
}
