/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kosmos.usinesite.reference;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;

public class BeanReference {

	private Map<String, String> newValuesByOldValues;

	private Map<String, Collection<String>> modulesBySearchString;

	public Map<String, String> getNewValuesByOldValues() {
		return newValuesByOldValues;
	}

	public void setNewValuesByOldValues(final Map<String, String> newValuesByOldValues) {
		this.newValuesByOldValues = newValuesByOldValues;
	}

	public void addNewValueByOldValue(final String oldValue, final String newValue) {
		if (newValuesByOldValues == null) {
			newValuesByOldValues = new HashMap<>();
		}
		newValuesByOldValues.put(oldValue, newValue);
	}

	public Map<String, Collection<String>> getModulesBySearchString() {
		return modulesBySearchString;
	}

	public void setModulesBySearchString(final Map<String, Collection<String>> modulesBySearchString) {
		this.modulesBySearchString = modulesBySearchString;
	}

	@SuppressWarnings("unchecked")
	public void addModulesBySearchString(final String value, final Collection<String> modules) {
		if (modulesBySearchString == null) {
			modulesBySearchString = new HashMap<>();
		}
		if (modulesBySearchString.containsKey(value)) {
			modulesBySearchString.put(value, CollectionUtils.union(modulesBySearchString.get(value), modules));
		} else {
			modulesBySearchString.put(value, modules);
		}
	}

	@SuppressWarnings("unchecked")
	public void addAllModulesBySearchString(Map<String, Collection<String>> map) {
		if (modulesBySearchString == null) {
			modulesBySearchString = new HashMap<>();
		}
		for (Map.Entry<String, Collection<String>> currentEntry : map.entrySet()) {
			if (modulesBySearchString.containsKey(currentEntry.getKey())) {
				modulesBySearchString.put(currentEntry.getKey(), CollectionUtils.union(modulesBySearchString.get(currentEntry.getKey()), currentEntry.getValue()));
			} else {
				modulesBySearchString.put(currentEntry.getKey(), currentEntry.getValue());
			}
		}
	}
}
